/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.filters;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.filters.FilterMessages;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDescriptor
implements Comparable<FilterDescriptor>,
IPluginContribution {
    private static String PATTERN_FILTER_ID_PREFIX = "_patternFilterId_";
    private static final String EXTENSION_POINT_NAME = "javaElementFilters";
    private static final String FILTER_TAG = "filter";
    private static final String PATTERN_ATTRIBUTE = "pattern";
    private static final String ID_ATTRIBUTE = "id";
    private static final String VIEW_ID_ATTRIBUTE = "viewId";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String SELECTED_ATTRIBUTE = "selected";
    private static FilterDescriptor[] fgFilterDescriptors;
    private IConfigurationElement fElement;

    public static FilterDescriptor[] getFilterDescriptors() {
        if (fgFilterDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.jdt.ui", EXTENSION_POINT_NAME);
            fgFilterDescriptors = FilterDescriptor.createFilterDescriptors(elements);
        }
        return fgFilterDescriptors;
    }

    public static FilterDescriptor[] getFilterDescriptors(String targetId) {
        FilterDescriptor[] filterDescs = FilterDescriptor.getFilterDescriptors();
        ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>(filterDescs.length);
        int i = 0;
        while (i < filterDescs.length) {
            String tid = filterDescs[i].getTargetId();
            if (!WorkbenchActivityHelper.filterItem((Object)filterDescs[i]) && (tid == null || tid.equals(targetId))) {
                result.add(filterDescs[i]);
            }
            ++i;
        }
        return result.toArray(new FilterDescriptor[result.size()]);
    }

    private FilterDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isTrue(this.isPatternFilter() ^ this.isCustomFilter(), "An extension for extension-point org.eclipse.jdt.ui.javaElementFilters does not specify a correct filter");
        Assert.isNotNull(this.getId(), "An extension for extension-point org.eclipse.jdt.ui.javaElementFilters does not provide a valid ID");
        Assert.isNotNull(this.getName(), "An extension for extension-point org.eclipse.jdt.ui.javaElementFilters does not provide a valid name");
    }

    public ViewerFilter createViewerFilter() {
        if (!this.isCustomFilter()) {
            return null;
        }
        final ViewerFilter[] result = new ViewerFilter[1];
        String message = Messages.format(FilterMessages.FilterDescriptor_filterCreationError_message, this.getId());
        SafeRunnable code = new SafeRunnable(message){

            public void run() throws Exception {
                result[0] = (ViewerFilter)FilterDescriptor.this.fElement.createExecutableExtension(FilterDescriptor.CLASS_ATTRIBUTE);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return result[0];
    }

    public String getId() {
        if (this.isPatternFilter()) {
            String targetId = this.getTargetId();
            if (targetId == null) {
                return String.valueOf(PATTERN_FILTER_ID_PREFIX) + this.getPattern();
            }
            return String.valueOf(targetId) + PATTERN_FILTER_ID_PREFIX + this.getPattern();
        }
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.isPatternFilter()) {
            name = this.getPattern();
        }
        return name;
    }

    public String getPattern() {
        return this.fElement.getAttribute(PATTERN_ATTRIBUTE);
    }

    public String getTargetId() {
        String tid = this.fElement.getAttribute(TARGET_ID_ATTRIBUTE);
        if (tid != null) {
            return tid;
        }
        return this.fElement.getAttribute(VIEW_ID_ATTRIBUTE);
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public boolean isPatternFilter() {
        return this.getPattern() != null;
    }

    public boolean isCustomFilter() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE) != null;
    }

    public boolean isEnabled() {
        String strVal = this.fElement.getAttribute(ENABLED_ATTRIBUTE);
        if (strVal == null) {
            strVal = this.fElement.getAttribute(SELECTED_ATTRIBUTE);
        }
        return strVal == null || Boolean.valueOf(strVal) != false;
    }

    @Override
    public int compareTo(FilterDescriptor o) {
        return Collator.getInstance().compare(this.getName(), o.getName());
    }

    private static FilterDescriptor[] createFilterDescriptors(IConfigurationElement[] elements) {
        ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        int i = 0;
        while (i < elements.length) {
            final IConfigurationElement element = elements[i];
            if (FILTER_TAG.equals(element.getName())) {
                final FilterDescriptor[] desc = new FilterDescriptor[1];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(FilterMessages.FilterDescriptor_filterDescriptionCreationError_message){

                    public void run() throws Exception {
                        desc[0] = new FilterDescriptor(element, null);
                    }
                });
                if (desc[0] != null && !descIds.contains(desc[0].getId())) {
                    result.add(desc[0]);
                    descIds.add(desc[0].getId());
                }
            }
            ++i;
        }
        return result.toArray(new FilterDescriptor[result.size()]);
    }

    public String getLocalId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getPluginId() {
        return this.fElement.getContributor().getName();
    }

    /* synthetic */ FilterDescriptor(IConfigurationElement iConfigurationElement, FilterDescriptor filterDescriptor) {
        this(iConfigurationElement);
    }
}

