/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public abstract class FatJarAntExporter {
    private ILaunchConfiguration fLaunchConfiguration;
    private IPath fAbsJarfile;
    private IPath fAntScriptLocation;

    public FatJarAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
        this.fAbsJarfile = jarLocation;
        this.fAntScriptLocation = antScriptLocation;
    }

    public void run(MultiStatus status) throws CoreException {
        try {
            IPath[] classpath = FatJarAntExporter.getClasspath(this.fLaunchConfiguration);
            String mainClass = FatJarAntExporter.getMainClass(this.fLaunchConfiguration, status);
            String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            this.buildANTScript(this.fAntScriptLocation, projectName, this.fAbsJarfile, mainClass, FatJarAntExporter.convert(classpath));
        }
        catch (FileNotFoundException e) {
            throw new CoreException(new Status(4, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizard_antScript_error_readingOutputFile, new Object[]{BasicElementLabels.getPathLabel(this.fAntScriptLocation, true), e.getLocalizedMessage()})));
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizard_antScript_error_writingOutputFile, new Object[]{BasicElementLabels.getPathLabel(this.fAntScriptLocation, true), e.getLocalizedMessage()})));
        }
    }

    private static IPath[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPath entry;
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !userEntries.contains(entry = Path.fromOSString(location))) {
                userEntries.add(entry);
            }
            ++i;
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    private static String getMainClass(ILaunchConfiguration launchConfig, MultiStatus status) {
        String result = null;
        if (launchConfig != null) {
            try {
                result = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        if (result == null) {
            status.add(new Status(2, "org.eclipse.jdt.ui", FatJarPackagerMessages.FatJarPackageWizardPage_LaunchConfigurationWithoutMainType_warning));
            result = "";
        }
        return result;
    }

    protected static SourceInfo[] convert(IPath[] classpath) {
        SourceInfo[] result = new SourceInfo[classpath.length];
        int i = 0;
        while (i < classpath.length) {
            IPath path = classpath[i];
            if (path != null) {
                if (path.toFile().isDirectory()) {
                    result[i] = new SourceInfo(false, path.toString(), "");
                } else if (path.toFile().isFile()) {
                    result[i] = new SourceInfo(true, path.toString(), "");
                }
            }
            ++i;
        }
        return result;
    }

    protected abstract void buildANTScript(IPath var1, String var2, IPath var3, String var4, SourceInfo[] var5) throws IOException;

    protected static class SourceInfo {
        public final boolean isJar;
        public final String absPath;
        public final String relJarPath;

        public SourceInfo(boolean isJar, String absPath, String relJarPath) {
            this.isJar = isJar;
            this.absPath = absPath;
            this.relJarPath = relJarPath;
        }
    }
}

