/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.AbstractJarDestinationWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarRsrcUrlAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarRsrcUrlBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.UnpackFatJarAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.UnpackFatJarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.UnpackJarAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.UnpackJarBuilder;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FatJarPackageWizardPage
extends AbstractJarDestinationWizardPage {
    private static final String PAGE_NAME = "FatJarPackageWizardPage";
    private static final String STORE_LAUNCH_CONFIGURATION_SELECTION_NAME = "FatJarPackageWizardPage.LAUNCH_CONFIGURATION_SELECTION_NAME";
    private static final String STORE_DESTINATION_ELEMENT = "FatJarPackageWizardPage.DESTINATION_PATH_SELECTION";
    private static final String STORE_ANTSCRIPT_SAVE = "FatJarPackageWizardPage.ANTSCRIPT_SAVE";
    private static final String STORE_ANTSCRIPT_LOCATION = "FatJarPackageWizardPage.ANTSCRIPT_LOCATION";
    private static final String STORE_ANTSCRIPT_LOCATION_HISTORY = "FatJarPackageWizardPage.ANTSCRIPT_LOCATION_HISTORY";
    private static final String STORE_LIBRARY_HANDLING = "FatJarPackageWizardPage.LIBRARY_HANDLING";
    private static final String ANTSCRIPT_EXTENSION = "xml";
    private final JarPackageData fJarPackage;
    private LibraryHandler fLibraryHandler;
    private final ArrayList<LaunchConfigurationElement> fLauchConfigurationModel;
    private Combo fLaunchConfigurationCombo;
    private Button fAntScriptSaveCheckbox;
    private Label fAntScriptLabel;
    private Combo fAntScriptNamesCombo;
    private Button fAntScriptBrowseButton;
    private IPath fAntScriptLocation;
    private Composite fLibraryHandlingGroup;
    private Button fExtractJarsRadioButton;
    private Button fPackageJarsRadioButton;
    private Button fCopyJarFilesRadioButton;

    public FatJarPackageWizardPage(JarPackageData jarPackage, IStructuredSelection selection) {
        super(PAGE_NAME, selection, jarPackage);
        this.setTitle(FatJarPackagerMessages.JarPackageWizardPage_title);
        this.setDescription(FatJarPackagerMessages.FatJarPackageWizardPage_description);
        this.fJarPackage = jarPackage;
        this.fLauchConfigurationModel = new ArrayList();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createContentGroup(composite);
        this.createLibraryHandlingGroup(composite);
        Label seperator = new Label(composite, 258);
        seperator.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createAntScriptGroup(composite);
        this.restoreWidgetValues();
        this.update();
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void createContentGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(composite, FatJarPackagerMessages.FatJarPackageWizardPage_launchConfigGroupTitle, false);
        this.createLaunchConfigSelectionGroup(composite);
        this.createLabel(composite, FatJarPackagerMessages.FatJarPackageWizardPage_destinationGroupTitle, false);
        this.createDestinationGroup(composite);
    }

    protected String getDestinationLabel() {
        return null;
    }

    private void createLaunchConfigSelectionGroup(Composite parent) {
        this.fLaunchConfigurationCombo = new Combo(parent, 12);
        SWTUtil.setDefaultVisibleItemCount(this.fLaunchConfigurationCombo);
        this.fLaunchConfigurationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fLauchConfigurationModel.addAll(Arrays.asList(this.getLaunchConfigurations()));
        String[] names = new String[this.fLauchConfigurationModel.size()];
        int i = 0;
        int size = this.fLauchConfigurationModel.size();
        while (i < size) {
            LaunchConfigurationElement element = this.fLauchConfigurationModel.get(i);
            names[i] = element.getLaunchConfigurationName();
            ++i;
        }
        this.fLaunchConfigurationCombo.setItems(names);
        this.fLaunchConfigurationCombo.addListener(13, (Listener)this);
        this.fLaunchConfigurationCombo.addListener(24, (Listener)this);
    }

    private void createAntScriptGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.fAntScriptSaveCheckbox = new Button(composite, 16416);
        this.fAntScriptSaveCheckbox.setText(FatJarPackagerMessages.FatJarPackageWizardPage_saveAntScript_text);
        this.fAntScriptSaveCheckbox.addListener(13, (Listener)this);
        GridData data = new GridData(1);
        data.horizontalSpan = 3;
        this.fAntScriptSaveCheckbox.setLayoutData((Object)data);
        this.fAntScriptLabel = this.createLabel(composite, FatJarPackagerMessages.FatJarPackageWizardPage_antScriptLocation_text, false);
        this.fAntScriptNamesCombo = new Combo(composite, 2052);
        SWTUtil.setDefaultVisibleItemCount(this.fAntScriptNamesCombo);
        this.fAntScriptNamesCombo.addListener(24, (Listener)this);
        this.fAntScriptNamesCombo.addListener(13, (Listener)this);
        data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 1;
        this.fAntScriptNamesCombo.setLayoutData((Object)data);
        this.fAntScriptBrowseButton = new Button(composite, 8);
        this.fAntScriptBrowseButton.setText(FatJarPackagerMessages.FatJarPackageWizardPage_antScriptLocationBrowse_text);
        this.fAntScriptBrowseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fAntScriptBrowseButton);
        this.fAntScriptBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FatJarPackageWizardPage.this.handleAntScriptBrowseButtonPressed();
            }
        });
    }

    private void handleAntScriptBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String currentSourceString = this.getAntScriptValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.fAntScriptNamesCombo.setText(selectedFileName);
        }
    }

    private String getAntScriptValue() {
        String antScriptText = this.fAntScriptNamesCombo.getText().trim();
        if (antScriptText.indexOf(46) < 0) {
            antScriptText = String.valueOf(antScriptText) + ".xml";
        }
        return antScriptText;
    }

    protected Label createLabel(Composite parent, String text, boolean bold) {
        Label label = new Label(parent, 0);
        if (bold) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(text);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void createLibraryHandlingGroup(Composite parent) {
        this.fLibraryHandlingGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.fLibraryHandlingGroup.setLayout((Layout)layout);
        this.fLibraryHandlingGroup.setLayoutData((Object)new GridData(784));
        this.createLabel(this.fLibraryHandlingGroup, FatJarPackagerMessages.FatJarPackageWizardPage_libraryHandlingGroupTitle, false);
        this.fExtractJarsRadioButton = new Button(this.fLibraryHandlingGroup, 16400);
        this.fExtractJarsRadioButton.setText(FatJarPackagerMessages.FatJarPackageWizardPage_extractJars_text);
        this.fExtractJarsRadioButton.setLayoutData((Object)new GridData(768));
        this.fExtractJarsRadioButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    FatJarPackageWizardPage.this.fLibraryHandler = new ExtractLibraryHandler();
                }
            }
        });
        this.fPackageJarsRadioButton = new Button(this.fLibraryHandlingGroup, 16400);
        this.fPackageJarsRadioButton.setText(FatJarPackagerMessages.FatJarPackageWizardPage_packageJars_text);
        this.fPackageJarsRadioButton.setLayoutData((Object)new GridData(768));
        this.fPackageJarsRadioButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    FatJarPackageWizardPage.this.fLibraryHandler = new PackageLibraryHandler();
                }
            }
        });
        this.fCopyJarFilesRadioButton = new Button(this.fLibraryHandlingGroup, 16400);
        this.fCopyJarFilesRadioButton.setText(FatJarPackagerMessages.FatJarPackageWizardPage_copyJarFiles_text);
        this.fCopyJarFilesRadioButton.setLayoutData((Object)new GridData(768));
        this.fCopyJarFilesRadioButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    FatJarPackageWizardPage.this.fLibraryHandler = new CopyLibraryHandler();
                }
            }
        });
        this.setLibraryHandler(new ExtractLibraryHandler());
    }

    public LibraryHandler getLibraryHandler() {
        return this.fLibraryHandler;
    }

    public void setLibraryHandler(LibraryHandler libraryHandler) {
        this.fLibraryHandler = libraryHandler;
        this.fExtractJarsRadioButton.setSelection(libraryHandler.getID() == 1);
        this.fPackageJarsRadioButton.setSelection(libraryHandler.getID() == 2);
        this.fCopyJarFilesRadioButton.setSelection(libraryHandler.getID() == 3);
    }

    LibraryHandler createLibraryHandlerById(int handlerId) {
        if (handlerId == 2) {
            return new PackageLibraryHandler();
        }
        if (handlerId == 3) {
            return new CopyLibraryHandler();
        }
        return new ExtractLibraryHandler();
    }

    protected void updateModel() {
        super.updateModel();
        String comboText = this.fAntScriptNamesCombo.getText();
        IPath path = Path.fromOSString(comboText);
        if (path.segmentCount() > 0 && this.ensureAntScriptFileIsValid(path.toFile()) && path.getFileExtension() == null) {
            path = path.addFileExtension(ANTSCRIPT_EXTENSION);
        }
        this.fAntScriptLocation = path;
    }

    protected void updateWidgetEnablements() {
        boolean antScriptSave = this.fAntScriptSaveCheckbox.getSelection();
        this.fAntScriptLabel.setEnabled(antScriptSave);
        this.fAntScriptNamesCombo.setEnabled(antScriptSave);
        this.fAntScriptBrowseButton.setEnabled(antScriptSave);
    }

    public boolean isPageComplete() {
        this.clearMessages();
        boolean complete = this.validateDestinationGroup();
        complete = this.validateLaunchConfigurationGroup() && complete;
        complete = this.validateAntScriptGroup() && complete;
        return complete;
    }

    private boolean validateLaunchConfigurationGroup() {
        int index = this.fLaunchConfigurationCombo.getSelectionIndex();
        if (index == -1) {
            return false;
        }
        LaunchConfigurationElement element = this.fLauchConfigurationModel.get(index);
        if (element.hasProgramArguments()) {
            this.setWarningMessage(FatJarPackagerMessages.FatJarPackageWizardPage_warning_launchConfigContainsProgramArgs);
        }
        if (element.hasVMArguments()) {
            this.setWarningMessage(FatJarPackagerMessages.FatJarPackageWizardPage_warning_launchConfigContainsVMArgs);
        }
        return true;
    }

    private boolean validateAntScriptGroup() {
        if (!this.fAntScriptSaveCheckbox.getSelection()) {
            return true;
        }
        if (this.fAntScriptNamesCombo.getText().length() == 0) {
            this.setErrorMessage(FatJarPackagerMessages.FatJarPackageWizardPage_error_antScriptLocationMissing);
            return false;
        }
        if (this.fAntScriptLocation.toString().endsWith("/")) {
            this.setErrorMessage(FatJarPackagerMessages.FatJarPackageWizardPage_error_antScriptLocationIsDir);
            this.fAntScriptNamesCombo.setFocus();
            return false;
        }
        if (!new File(this.fAntScriptNamesCombo.getText()).isAbsolute()) {
            this.setInfoMessage(FatJarPackagerMessages.FatJarPackageWizardPage_info_antScriptLocationRelative);
        }
        return this.ensureAntScriptFileIsValid(this.fAntScriptLocation.toFile());
    }

    private boolean ensureAntScriptFileIsValid(File antScriptFile) {
        if (antScriptFile.exists() && antScriptFile.isDirectory() && this.fAntScriptNamesCombo.getText().length() > 0) {
            this.setErrorMessage(FatJarPackagerMessages.FatJarPackageWizardPage_error_antScriptLocationIsDir);
            this.fAntScriptNamesCombo.setFocus();
            return false;
        }
        if (antScriptFile.exists() && !antScriptFile.canWrite()) {
            this.setErrorMessage(FatJarPackagerMessages.FatJarPackageWizardPage_error_antScriptLocationUnwritable);
            this.fAntScriptNamesCombo.setFocus();
            return false;
        }
        return true;
    }

    private void clearMessages() {
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        if (this.getMessage() != null) {
            this.setMessage(null);
        }
    }

    private void setWarningMessage(String newMessage) {
        if (this.getMessage() == null || this.getMessageType() < 2) {
            this.setMessage(newMessage, 2);
        }
    }

    private void setInfoMessage(String newMessage) {
        if (this.getMessage() == null || this.getMessageType() < 1) {
            this.setMessage(newMessage, 1);
        }
    }

    private LaunchConfigurationElement[] getLaunchConfigurations() {
        ArrayList<ExistingLaunchConfigurationElement> result = new ArrayList<ExistingLaunchConfigurationElement>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfiguration[] launchconfigs = manager.getLaunchConfigurations(type);
            int i = 0;
            while (i < launchconfigs.length) {
                ILaunchConfiguration launchconfig = launchconfigs[i];
                if (!launchconfig.getAttribute("org.eclipse.debug.ui.private", false)) {
                    String projectName = launchconfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                    result.add(new ExistingLaunchConfigurationElement(launchconfig, projectName));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return result.toArray(new LaunchConfigurationElement[result.size()]);
    }

    public Object[] getSelectedElementsWithoutContainedChildren(MultiStatus status) {
        try {
            LaunchConfigurationElement element = this.fLauchConfigurationModel.get(this.fLaunchConfigurationCombo.getSelectionIndex());
            ILaunchConfiguration launchconfig = element.getLaunchConfiguration();
            this.fJarPackage.setLaunchConfigurationName(element.getLaunchConfigurationName());
            return FatJarPackageWizardPage.getSelectedElementsWithoutContainedChildren(launchconfig, this.fJarPackage, (IRunnableContext)this.getContainer(), status);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    private static IJavaProject[] getProjectSearchOrder(String projectName) {
        ArrayList<String> projectNames = new ArrayList<String>();
        projectNames.add(projectName);
        int nextProject = 0;
        while (nextProject < projectNames.size()) {
            String nextProjectName = (String)projectNames.get(nextProject);
            IJavaProject jproject = FatJarPackageWizardPage.getJavaProject(nextProjectName);
            if (jproject != null) {
                try {
                    String[] childProjectNames = jproject.getRequiredProjectNames();
                    int i = 0;
                    while (i < childProjectNames.length) {
                        if (!projectNames.contains(childProjectNames[i])) {
                            projectNames.add(childProjectNames[i]);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            ++nextProject;
        }
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
        int i = 0;
        int size = projectNames.size();
        while (i < size) {
            String name = (String)projectNames.get(i);
            IJavaProject project = FatJarPackageWizardPage.getJavaProject(name);
            if (project != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    private static IJavaProject getJavaProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        IJavaProject result = JavaCore.create(project);
        if (result == null) {
            return null;
        }
        if (!result.exists()) {
            return null;
        }
        return result;
    }

    private static IPath[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPath entry;
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !userEntries.contains(entry = Path.fromOSString(location))) {
                userEntries.add(entry);
            }
            ++i;
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    private static String getMainClass(ILaunchConfiguration launchConfig, MultiStatus status) {
        String result = null;
        if (launchConfig != null) {
            try {
                result = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        if (result == null) {
            status.add(new Status(2, "org.eclipse.jdt.ui", FatJarPackagerMessages.FatJarPackageWizardPage_LaunchConfigurationWithoutMainType_warning));
            result = "";
        }
        return result;
    }

    private static IPackageFragmentRoot[] getRequiredPackageFragmentRoots(IPath[] classpathEntries, String projectName, MultiStatus status) {
        HashSet<IPackageFragmentRoot> result = new HashSet<IPackageFragmentRoot>();
        IJavaProject[] searchOrder = FatJarPackageWizardPage.getProjectSearchOrder(projectName);
        int i = 0;
        while (i < classpathEntries.length) {
            IPath entry = classpathEntries[i];
            IPackageFragmentRoot[] elements = FatJarPackageWizardPage.findRootsForClasspath(entry, searchOrder);
            if (elements == null) {
                status.add(new Status(2, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizardPage_error_missingClassFile, BasicElementLabels.getPathLabel(entry, false))));
            } else {
                int j = 0;
                while (j < elements.length) {
                    result.add(elements[j]);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private static IPackageFragmentRoot[] findRootsForClasspath(IPath entry, IJavaProject[] searchOrder) {
        int i = 0;
        while (i < searchOrder.length) {
            IPackageFragmentRoot[] elements = FatJarPackageWizardPage.findRootsInProject(entry, searchOrder[i]);
            if (elements.length != 0) {
                return elements;
            }
            ++i;
        }
        return null;
    }

    private static IPackageFragmentRoot[] findRootsInProject(IPath entry, IJavaProject project) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot packageFragmentRoot = roots[i];
                if (FatJarPackageWizardPage.isRootAt(packageFragmentRoot, entry)) {
                    result.add(packageFragmentRoot);
                }
                ++i;
            }
        }
        catch (Exception e) {
            JavaPlugin.log(e);
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private static boolean isRootAt(IPackageFragmentRoot root, IPath entry) {
        IResource resource;
        try {
            IClasspathEntry cpe = root.getRawClasspathEntry();
            if (cpe.getEntryKind() == 3) {
                IPath location;
                IPath outputLocation = cpe.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = root.getJavaProject().getOutputLocation();
                }
                if (entry.equals(location = ResourcesPlugin.getWorkspace().getRoot().findMember(outputLocation).getLocation())) {
                    return true;
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        if ((resource = root.getResource()) != null && entry.equals(resource.getLocation())) {
            return true;
        }
        IPath path = root.getPath();
        return path != null && entry.equals(path);
    }

    private static IType findMainMethodByName(String name, IPackageFragmentRoot[] classpathResources, IRunnableContext context) {
        List<IResource> resources = JarPackagerUtil.asResources(classpathResources);
        if (resources == null) {
            return null;
        }
        Iterator<IResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            IResource element = iterator.next();
            if (element != null) continue;
            iterator.remove();
        }
        IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(resources.toArray(new IResource[resources.size()]), true);
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        try {
            IType[] mainTypes = engine.searchMainMethods(context, searchScope, 0);
            int i = 0;
            while (i < mainTypes.length) {
                if (mainTypes[i].getFullyQualifiedName().equals(name)) {
                    return mainTypes[i];
                }
                ++i;
            }
        }
        catch (InvocationTargetException ex) {
            JavaPlugin.log(ex);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.fLauchConfigurationModel != null) {
            int i = 0;
            int size = this.fLauchConfigurationModel.size();
            while (i < size) {
                LaunchConfigurationElement element = this.fLauchConfigurationModel.get(i);
                element.dispose();
                ++i;
            }
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String destinationPath;
            String[] directoryNames;
            this.fAntScriptSaveCheckbox.setSelection(settings.getBoolean(STORE_ANTSCRIPT_SAVE));
            String antScriptLocation = settings.get(STORE_ANTSCRIPT_LOCATION);
            if (antScriptLocation != null) {
                this.fAntScriptLocation = Path.fromOSString(antScriptLocation);
                if (this.fAntScriptLocation.isEmpty()) {
                    this.fAntScriptNamesCombo.setText("");
                } else {
                    this.fAntScriptNamesCombo.setText(this.fAntScriptLocation.toOSString());
                }
            }
            if ((directoryNames = settings.getArray(STORE_ANTSCRIPT_LOCATION_HISTORY)) != null) {
                if (!this.fAntScriptNamesCombo.getText().equals(directoryNames[0])) {
                    this.fAntScriptNamesCombo.add(this.fAntScriptNamesCombo.getText());
                }
                int i = 0;
                while (i < directoryNames.length) {
                    this.fAntScriptNamesCombo.add(directoryNames[i]);
                    ++i;
                }
            }
            int libraryHandling = 1;
            try {
                libraryHandling = settings.getInt(STORE_LIBRARY_HANDLING);
            }
            catch (NumberFormatException numberFormatException) {}
            this.setLibraryHandler(this.createLibraryHandlerById(libraryHandling));
            String name = settings.get(STORE_LAUNCH_CONFIGURATION_SELECTION_NAME);
            if (name != null) {
                String[] items = this.fLaunchConfigurationCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (name.equals(items[i])) {
                        this.fLaunchConfigurationCombo.select(i);
                    }
                    ++i;
                }
            }
            if ((destinationPath = settings.get(STORE_DESTINATION_ELEMENT)) != null && destinationPath.length() > 0) {
                this.fJarPackage.setJarLocation(Path.fromOSString(destinationPath));
            }
        }
        super.restoreWidgetValues();
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_ANTSCRIPT_SAVE, this.fAntScriptSaveCheckbox.getSelection());
            IPath antScriptLocation = this.fAntScriptLocation;
            if (antScriptLocation == null) {
                settings.put(STORE_ANTSCRIPT_LOCATION, "");
            } else {
                settings.put(STORE_ANTSCRIPT_LOCATION, antScriptLocation.toOSString());
            }
            String[] directoryNames = settings.getArray(STORE_ANTSCRIPT_LOCATION_HISTORY);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getAntScriptValue());
            settings.put(STORE_ANTSCRIPT_LOCATION_HISTORY, directoryNames);
            settings.put(STORE_LIBRARY_HANDLING, this.getLibraryHandler().getID());
            int index = this.fLaunchConfigurationCombo.getSelectionIndex();
            if (index == -1) {
                settings.put(STORE_LAUNCH_CONFIGURATION_SELECTION_NAME, "");
            } else {
                String selectedItem = this.fLaunchConfigurationCombo.getItem(index);
                settings.put(STORE_LAUNCH_CONFIGURATION_SELECTION_NAME, selectedItem);
            }
            IPath location = this.fJarPackage.getJarLocation();
            if (location == null) {
                settings.put(STORE_DESTINATION_ELEMENT, "");
            } else {
                settings.put(STORE_DESTINATION_ELEMENT, location.toOSString());
            }
        }
    }

    public static Object[] getSelectedElementsWithoutContainedChildren(ILaunchConfiguration launchconfig, JarPackageData data, IRunnableContext context, MultiStatus status) throws CoreException {
        if (launchconfig == null) {
            return new Object[0];
        }
        String projectName = launchconfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        IPath[] classpath = FatJarPackageWizardPage.getClasspath(launchconfig);
        Object[] classpathResources = FatJarPackageWizardPage.getRequiredPackageFragmentRoots(classpath, projectName, status);
        String mainClass = FatJarPackageWizardPage.getMainClass(launchconfig, status);
        IType mainType = FatJarPackageWizardPage.findMainMethodByName(mainClass, (IPackageFragmentRoot[])classpathResources, context);
        if (mainType == null) {
            status.add(new Status(4, "org.eclipse.jdt.ui", FatJarPackagerMessages.FatJarPackageWizardPage_error_noMainMethod));
        }
        data.setManifestMainClass(mainType);
        return classpathResources;
    }

    public void exportAntScript(MultiStatus status) {
        if (!this.fAntScriptSaveCheckbox.getSelection()) {
            return;
        }
        if (this.canCreateAntScript(this.getShell())) {
            LaunchConfigurationElement element = this.fLauchConfigurationModel.get(this.fLaunchConfigurationCombo.getSelectionIndex());
            Assert.isNotNull(element);
            FatJarAntExporter antExporter = this.getLibraryHandler().getAntExporter(this.fAntScriptLocation, this.fJarPackage.getAbsoluteJarLocation(), element.getLaunchConfiguration());
            try {
                antExporter.run(status);
            }
            catch (CoreException e) {
                status.add(new Status(4, "org.eclipse.jdt.ui", FatJarPackagerMessages.FatJarPackageWizardPage_error_ant_script_generation_failed, e));
            }
        }
    }

    private boolean canCreateAntScript(Shell parent) {
        File file = this.fAntScriptLocation.toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && JarPackagerUtil.askForOverwritePermission(parent, this.fAntScriptLocation, true);
        }
        String path = file.getAbsolutePath();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        File directory = new File(path.substring(0, separatorIndex));
        if (!directory.exists()) {
            if (FatJarPackagerUtil.askToCreateAntScriptDirectory(parent, directory)) {
                return directory.mkdirs();
            }
            return false;
        }
        return true;
    }

    public static class CopyLibraryHandler
    extends LibraryHandler {
        public static final int ID = 3;

        public FatJarAntExporter getAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
            return new UnpackJarAntExporter(antScriptLocation, jarLocation, launchConfiguration);
        }

        public FatJarBuilder getBuilder(JarPackageData jarPackageData) {
            return new UnpackJarBuilder(jarPackageData);
        }

        public int getID() {
            return 3;
        }

        public boolean isShowWarning() {
            return false;
        }
    }

    private static class ExistingLaunchConfigurationElement
    extends LaunchConfigurationElement {
        private final ILaunchConfiguration fLaunchConfiguration;
        private final String fProjectName;

        public ExistingLaunchConfigurationElement(ILaunchConfiguration launchConfiguration, String projectName) {
            this.fLaunchConfiguration = launchConfiguration;
            this.fProjectName = projectName;
        }

        public ILaunchConfiguration getLaunchConfiguration() {
            return this.fLaunchConfiguration;
        }

        public String getLaunchConfigurationName() {
            StringBuffer result = new StringBuffer();
            result.append(this.fLaunchConfiguration.getName());
            result.append(" - ");
            result.append(this.fProjectName);
            return result.toString();
        }

        public boolean hasProgramArguments() {
            try {
                return this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null) != null;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return false;
            }
        }

        public boolean hasVMArguments() {
            try {
                return this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null) != null;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return false;
            }
        }
    }

    public static class ExtractLibraryHandler
    extends LibraryHandler {
        public static final int ID = 1;

        public FatJarAntExporter getAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
            return new UnpackFatJarAntExporter(antScriptLocation, jarLocation, launchConfiguration);
        }

        public FatJarBuilder getBuilder(JarPackageData jarPackageData) {
            return new UnpackFatJarBuilder();
        }

        public int getID() {
            return 1;
        }

        public boolean isShowWarning() {
            return true;
        }
    }

    private static abstract class LaunchConfigurationElement {
        private LaunchConfigurationElement() {
        }

        public abstract ILaunchConfiguration getLaunchConfiguration();

        public abstract String getLaunchConfigurationName();

        public abstract boolean hasProgramArguments();

        public abstract boolean hasVMArguments();

        public void dispose() {
        }
    }

    public static abstract class LibraryHandler {
        public abstract FatJarAntExporter getAntExporter(IPath var1, IPath var2, ILaunchConfiguration var3);

        public abstract FatJarBuilder getBuilder(JarPackageData var1);

        public abstract int getID();

        public abstract boolean isShowWarning();
    }

    public static class PackageLibraryHandler
    extends LibraryHandler {
        public static final int ID = 2;

        public FatJarAntExporter getAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
            return new FatJarRsrcUrlAntExporter(antScriptLocation, jarLocation, launchConfiguration);
        }

        public FatJarBuilder getBuilder(JarPackageData jarPackageData) {
            return new FatJarRsrcUrlBuilder();
        }

        public int getID() {
            return 2;
        }

        public boolean isShowWarning() {
            return false;
        }
    }
}

