/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class ClassFileEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.jdt.ui.ClassFileEditorInputFactory";
    public static final String KEY = "org.eclipse.jdt.ui.ClassFileIdentifier";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAdaptable createElement(IMemento memento) {
        IType type;
        IJavaElement element;
        block4: {
            String identifier = memento.getString(KEY);
            if (identifier == null) {
                return null;
            }
            element = JavaCore.create(identifier);
            try {
                if (element.exists() || !(element instanceof IClassFile)) return EditorUtility.getEditorInput((Object)element);
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
                IJavaProject project = element.getJavaProject();
                if (project == null) return EditorUtility.getEditorInput((Object)element);
                if ((type = project.findType(type.getFullyQualifiedName())) != null) break block4;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        element = type.getParent();
        return EditorUtility.getEditorInput((Object)element);
    }

    public static void saveState(IMemento memento, InternalClassFileEditorInput input) {
        IClassFile c = input.getClassFile();
        memento.putString(KEY, c.getHandleIdentifier());
    }
}

