/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;

public class EditorHighlightingSynchronizer
implements ILinkedModeListener {
    private final JavaEditor fEditor;
    private final boolean fWasOccurrencesOn;

    public EditorHighlightingSynchronizer(JavaEditor editor) {
        Assert.isLegal(editor != null);
        this.fEditor = editor;
        this.fWasOccurrencesOn = this.fEditor.isMarkingOccurrences();
        if (this.fWasOccurrencesOn && !this.isEditorDisposed()) {
            this.fEditor.uninstallOccurrencesFinder();
        }
    }

    public void left(LinkedModeModel environment, int flags) {
        if (this.fWasOccurrencesOn && !this.isEditorDisposed()) {
            this.fEditor.installOccurrencesFinder(true);
        }
    }

    private boolean isEditorDisposed() {
        return this.fEditor == null || this.fEditor.getSelectionProvider() == null;
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }
}

