/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDeclaredTypeDetector;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class JavaElementDeclaredTypeHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IJavaElement fElement;
    private final String fTypeSig;
    private final boolean fQualify;

    public JavaElementDeclaredTypeHyperlink(IRegion region, SelectionDispatchAction openAction, IJavaElement element, boolean qualify) {
        this(region, openAction, element, null, qualify);
    }

    public JavaElementDeclaredTypeHyperlink(IRegion region, SelectionDispatchAction openAction, IJavaElement element, String typeSig, boolean qualify) {
        Assert.isNotNull((Object)openAction);
        Assert.isNotNull(region);
        Assert.isNotNull(element);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fElement = element;
        this.fTypeSig = typeSig;
        this.fQualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            if (this.fTypeSig == null) {
                String elementLabel = JavaElementLabels.getElementLabel(this.fElement, JavaElementLabels.ALL_FULLY_QUALIFIED);
                return Messages.format(JavaEditorMessages.JavaElementDeclaredTypeHyperlink_hyperlinkText_qualified, new Object[]{elementLabel});
            }
            String type = Signature.toString(this.fTypeSig);
            return Messages.format(JavaEditorMessages.JavaElementDeclaredTypeHyperlink_hyperlinkText_qualified_signature, new Object[]{type});
        }
        return JavaEditorMessages.JavaElementDeclaredTypeHyperlink_hyperlinkText;
    }

    public void open() {
        int kind;
        String typeSignature = this.fTypeSig;
        if (typeSignature == null) {
            try {
                typeSignature = JavaElementHyperlinkDeclaredTypeDetector.getTypeSignature(this.fElement);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return;
            }
        }
        if ((kind = Signature.getTypeSignatureKind(typeSignature)) == 4) {
            typeSignature = Signature.getElementType(typeSignature);
        } else if (kind == 1) {
            typeSignature = Signature.getTypeErasure(typeSignature);
        }
        String typeName = Signature.toString(typeSignature);
        IJavaElement parent = this.fElement.getAncestor(7);
        if (parent == null) {
            this.openElementAndShowErrorInStatusLine();
            return;
        }
        try {
            String[][] resolvedType = ((IType)parent).resolveType(typeName);
            if (resolvedType == null || resolvedType.length == 0) {
                this.openElementAndShowErrorInStatusLine();
                return;
            }
            String qualTypeName = JavaModelUtil.concatenateName(resolvedType[0][0], resolvedType[0][1]);
            IType type = this.fElement.getJavaProject().findType(qualTypeName, (IProgressMonitor)null);
            if (type != null) {
                this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)type));
                return;
            }
            this.openElementAndShowErrorInStatusLine();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return;
        }
    }

    private void openElementAndShowErrorInStatusLine() {
        try {
            IEditorPart editor = JavaUI.openInEditor(this.fElement);
            editor.getSite().getShell().getDisplay().beep();
            if (editor instanceof JavaEditor) {
                ((JavaEditor)editor).setStatusLineErrorMessage(JavaEditorMessages.JavaElementDeclaredTypeHyperlink_error_msg);
            }
        }
        catch (PartInitException e) {
            JavaPlugin.log(e);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }
}

