/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class JavaElementReturnTypeHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IMethod fMethod;
    private final boolean fQualify;

    public JavaElementReturnTypeHyperlink(IRegion region, SelectionDispatchAction openAction, IMethod method, boolean qualify) {
        Assert.isNotNull((Object)openAction);
        Assert.isNotNull(region);
        Assert.isNotNull(method);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fMethod = method;
        this.fQualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            String methodLabel = JavaElementLabels.getElementLabel(this.fMethod, JavaElementLabels.ALL_FULLY_QUALIFIED);
            return Messages.format(JavaEditorMessages.JavaElementReturnTypeHyperlink_hyperlinkText_qualified, new Object[]{methodLabel});
        }
        return JavaEditorMessages.JavaElementReturnTypeHyperlink_hyperlinkText;
    }

    public void open() {
        try {
            String returnTypeSignature = this.fMethod.getReturnType();
            int kind = Signature.getTypeSignatureKind(returnTypeSignature);
            if (kind == 4) {
                returnTypeSignature = Signature.getElementType(returnTypeSignature);
            } else if (kind == 1) {
                returnTypeSignature = Signature.getTypeErasure(returnTypeSignature);
            }
            String returnType = Signature.toString(returnTypeSignature);
            String[][] resolvedType = this.fMethod.getDeclaringType().resolveType(returnType);
            if (resolvedType == null || resolvedType.length == 0) {
                this.openMethodAndShowErrorInStatusLine();
                return;
            }
            String typeName = JavaModelUtil.concatenateName(resolvedType[0][0], resolvedType[0][1]);
            IType type = this.fMethod.getJavaProject().findType(typeName, (IProgressMonitor)null);
            if (type != null) {
                this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)type));
                return;
            }
            this.openMethodAndShowErrorInStatusLine();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return;
        }
    }

    private void openMethodAndShowErrorInStatusLine() {
        try {
            IEditorPart editor = JavaUI.openInEditor(this.fMethod);
            editor.getSite().getShell().getDisplay().beep();
            if (editor instanceof JavaEditor) {
                ((JavaEditor)editor).setStatusLineErrorMessage(JavaEditorMessages.JavaElementReturnTypeHyperlink_error_msg);
            }
        }
        catch (PartInitException e) {
            JavaPlugin.log(e);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }
}

