/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JavaElementSuperImplementationHyperlink
implements IHyperlink {
    private final SelectionDispatchAction fOpenAction;
    private final IMethod fMethod;
    private final boolean fQualify;
    private IRegion fRegion;

    public JavaElementSuperImplementationHyperlink(IRegion region, SelectionDispatchAction openAction, IMethod method, boolean qualify) {
        Assert.isNotNull((Object)openAction);
        Assert.isNotNull(region);
        Assert.isNotNull(method);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fMethod = method;
        this.fQualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            String methodLabel = JavaElementLabels.getElementLabel(this.fMethod, JavaElementLabels.ALL_FULLY_QUALIFIED);
            return Messages.format(JavaEditorMessages.JavaElementSuperImplementationHyperlink_hyperlinkText_qualified, new Object[]{methodLabel});
        }
        return JavaEditorMessages.JavaElementSuperImplementationHyperlink_hyperlinkText;
    }

    public void open() {
        try {
            IMethod method = JavaElementSuperImplementationHyperlink.findSuperImplementation(this.fMethod);
            if (method != null) {
                this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)method));
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return;
        }
    }

    static IMethod findSuperImplementation(IMethod method) throws JavaModelException {
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(method.getDeclaringType());
        return tester.findOverriddenMethod(method, false);
    }
}

