/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectHistoryAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionHistory {
    private List<ISourceRange> fHistory;
    private JavaEditor fEditor;
    private ISelectionChangedListener fSelectionListener;
    private int fSelectionChangeListenerCounter;
    private StructureSelectHistoryAction fHistoryAction;

    public SelectionHistory(JavaEditor editor) {
        Assert.isNotNull(editor);
        this.fEditor = editor;
        this.fHistory = new ArrayList<ISourceRange>(3);
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectionHistory.this.fSelectionChangeListenerCounter == 0) {
                    SelectionHistory.this.flush();
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
    }

    public void setHistoryAction(StructureSelectHistoryAction action) {
        Assert.isNotNull((Object)action);
        this.fHistoryAction = action;
    }

    public boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public void remember(ISourceRange range) {
        this.fHistory.add(range);
        this.fHistoryAction.update();
    }

    public ISourceRange getLast() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.fHistory.size();
        ISourceRange result = this.fHistory.remove(size - 1);
        this.fHistoryAction.update();
        return result;
    }

    public void flush() {
        if (this.fHistory.isEmpty()) {
            return;
        }
        this.fHistory.clear();
        this.fHistoryAction.update();
    }

    public void ignoreSelectionChanges() {
        ++this.fSelectionChangeListenerCounter;
    }

    public void listenToSelectionChanges() {
        --this.fSelectionChangeListenerCounter;
    }

    public void dispose() {
        this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
    }
}

