/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class StructureSelectPreviousAction
extends StructureSelectionAction {
    public StructureSelectPreviousAction(JavaEditor editor, SelectionHistory history) {
        super(SelectionActionMessages.StructureSelectPrevious_label, editor, history);
        this.setToolTipText(SelectionActionMessages.StructureSelectPrevious_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectPrevious_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.structured_select_previous_action");
    }

    public StructureSelectPreviousAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        ASTNode previousNode;
        if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = PreviousNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectPreviousAction.getSelectedNodeSourceRange(sr, previousNode);
        }
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectPreviousAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectPreviousAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode previousNode2 = StructureSelectPreviousAction.getPreviousNode(parent, selAnalyzer.getSelectedNodes()[0]);
        if (previousNode2 == parent) {
            return StructureSelectPreviousAction.getSelectedNodeSourceRange(sr, parent);
        }
        int offset = previousNode2.getStartPosition();
        int end = oldSourceRange.getOffset() + oldSourceRange.getLength() - 1;
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getPreviousNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[0]) {
            return parent;
        }
        int index = StructureSelectionAction.findIndex(siblingNodes, node);
        if (index < 1) {
            return parent;
        }
        return siblingNodes[index - 1];
    }

    private static class PreviousNodeAnalyzer
    extends GenericVisitor {
        private final int fOffset;
        private ASTNode fPreviousNode;

        private PreviousNodeAnalyzer(int offset) {
            super(true);
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            PreviousNodeAnalyzer analyzer = new PreviousNodeAnalyzer(offset);
            lastCoveringNode.accept(analyzer);
            return analyzer.fPreviousNode;
        }

        protected boolean visitNode(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            if (end == this.fOffset) {
                this.fPreviousNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

