/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

class GotoTypeAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoTypeAction(PackageExplorerPart part) {
        this.setText(PackagesMessages.GotoType_action_label);
        this.setDescription(PackagesMessages.GotoType_action_description);
        this.fPackageExplorer = part;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.goto_type_action");
    }

    public void run() {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog(shell, (IRunnableContext)new ProgressMonitorDialog(shell), SearchEngine.createWorkspaceScope(), 256, false);
        }
        catch (JavaModelException e) {
            String title = this.getDialogTitle();
            String message = PackagesMessages.GotoType_error_message;
            ExceptionHandler.handle(e, title, message);
            return;
        }
        dialog.setTitle(this.getDialogTitle());
        dialog.setMessage(PackagesMessages.GotoType_dialog_message);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.gotoType((IType)types[0]);
        }
    }

    private void gotoType(IType type) {
        PackageExplorerPart view;
        ICompilationUnit cu = (ICompilationUnit)type.getAncestor(5);
        IJavaElement element = null;
        element = cu != null ? cu.getPrimary() : type.getAncestor(6);
        if (element != null && (view = PackageExplorerPart.openInActivePerspective()) != null) {
            view.selectReveal((ISelection)new StructuredSelection((Object)element));
            if (!element.equals(this.getSelectedElement(view))) {
                MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)Messages.format(PackagesMessages.PackageExplorer_element_not_present, JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT)));
            }
        }
    }

    private Object getSelectedElement(PackageExplorerPart view) {
        return ((IStructuredSelection)view.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.GotoType_dialog_title;
    }
}

