/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    private List<?> fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private JavaCopyProcessor fCopyProcessor;
    private int fCanCopyElements;
    private ISelection fSelection;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        this.setSelectionFeedbackEnabled(false);
        this.setFeedbackEnabled(false);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IJavaElement || target instanceof IResource;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.setSelectionFeedbackEnabled(false);
        this.fElements = null;
        this.fSelection = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.determineOperation(target, operation, transferType, 7) != 0;
    }

    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        int result = this.internalDetermineOperation(target, operation, operations);
        if (result == 0) {
            this.setSelectionFeedbackEnabled(false);
        } else {
            this.setSelectionFeedbackEnabled(true);
        }
        return result;
    }

    private int internalDetermineOperation(Object target, int operation, int operations) {
        this.initializeSelection();
        if (target == null) {
            return 0;
        }
        if (this.getCurrentLocation() == 3) {
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
            if (this.contains(javaElements, target)) {
                return 0;
            }
            IResource[] resources = ReorgUtils.getResources(this.fElements);
            if (this.contains(resources, target)) {
                return 0;
            }
        }
        try {
            switch (operation) {
                case 16: {
                    return this.handleValidateDefault(target, operations);
                }
                case 1: {
                    return this.handleValidateCopy(target);
                }
                case 2: {
                    return this.handleValidateMove(target);
                }
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
        }
        return 0;
    }

    private boolean contains(IResource[] resources, Object target) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(IJavaElement[] elements, Object target) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            this.fSelection = StructuredSelection.EMPTY;
            this.fElements = Collections.EMPTY_LIST;
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    public boolean performDrop(Object data) {
        try {
            switch (this.getCurrentOperation()) {
                case 2: {
                    return this.handleDropMove(this.getCurrentTarget());
                }
                case 1: {
                    return this.handleDropCopy(this.getCurrentTarget());
                }
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            return false;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private int handleValidateDefault(Object target, int operations) throws JavaModelException {
        int result;
        if ((operations & 2) != 0 && (result = this.handleValidateMove(target)) != 0) {
            return result;
        }
        return this.handleValidateCopy(target);
    }

    private int handleValidateMove(Object target) throws JavaModelException {
        IReorgPolicy.IMovePolicy policy;
        if (this.fMoveProcessor == null && (policy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements))).canEnable()) {
            this.fMoveProcessor = new JavaMoveProcessor(policy);
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (this.fMoveProcessor == null) {
            return 0;
        }
        RefactoringStatus moveStatus = this.fMoveProcessor.setDestination(ReorgDestinationFactory.createDestination(target, this.getCurrentLocation()));
        if (moveStatus.hasError()) {
            return 0;
        }
        return 2;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private boolean handleDropMove(Object target) throws JavaModelException, InvocationTargetException, InterruptedException {
        IResource[] resources;
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        ReorgMoveStarter starter = ReorgMoveStarter.create(javaElements, resources = ReorgUtils.getResources(this.fElements), ReorgDestinationFactory.createDestination(target, this.getCurrentLocation()));
        if (starter != null) {
            return starter.run(this.getShell());
        }
        return false;
    }

    private int handleValidateCopy(Object target) throws JavaModelException {
        if (this.fCopyProcessor == null) {
            IReorgPolicy.ICopyPolicy policy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
            JavaCopyProcessor javaCopyProcessor = this.fCopyProcessor = policy.canEnable() ? new JavaCopyProcessor(policy) : null;
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (this.fCopyProcessor == null) {
            return 0;
        }
        if (!this.fCopyProcessor.setDestination(ReorgDestinationFactory.createDestination(target, this.getCurrentLocation())).isOK()) {
            return 0;
        }
        return 1;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private boolean handleDropCopy(Object target) throws JavaModelException, InvocationTargetException, InterruptedException {
        IResource[] resources;
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        ReorgCopyStarter starter = ReorgCopyStarter.create(javaElements, resources = ReorgUtils.getResources(this.fElements), ReorgDestinationFactory.createDestination(target, this.getCurrentLocation()));
        if (starter != null) {
            starter.run(this.getShell());
            return true;
        }
        return false;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected int getCurrentLocation() {
        if (this.getFeedbackEnabled()) {
            return super.getCurrentLocation();
        }
        return 3;
    }
}

