/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MembersOrderPreferenceCache
implements IPropertyChangeListener {
    public static final int TYPE_INDEX = 0;
    public static final int CONSTRUCTORS_INDEX = 1;
    public static final int METHOD_INDEX = 2;
    public static final int FIELDS_INDEX = 3;
    public static final int INIT_INDEX = 4;
    public static final int STATIC_FIELDS_INDEX = 5;
    public static final int STATIC_INIT_INDEX = 6;
    public static final int STATIC_METHODS_INDEX = 7;
    public static final int ENUM_CONSTANTS_INDEX = 8;
    public static final int N_CATEGORIES = 9;
    private static final int PUBLIC_INDEX = 0;
    private static final int PRIVATE_INDEX = 1;
    private static final int PROTECTED_INDEX = 2;
    private static final int DEFAULT_INDEX = 3;
    private static final int N_VISIBILITIES = 4;
    private int[] fCategoryOffsets = null;
    private boolean fSortByVisibility = false;
    private int[] fVisibilityOffsets = null;
    private IPreferenceStore fPreferenceStore = null;

    public void install(IPreferenceStore store) {
        this.fPreferenceStore = store;
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fSortByVisibility = store.getBoolean("org.eclipse.jdt.ui.enable.visibility.order");
    }

    public void dispose() {
        this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fPreferenceStore = null;
    }

    public static boolean isMemberOrderProperty(String property) {
        return "outlinesortoption".equals(property) || "org.eclipse.jdt.ui.visibility.order".equals(property) || "org.eclipse.jdt.ui.enable.visibility.order".equals(property);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("outlinesortoption".equals(property)) {
            this.fCategoryOffsets = null;
        } else if ("org.eclipse.jdt.ui.visibility.order".equals(property)) {
            this.fVisibilityOffsets = null;
        } else if ("org.eclipse.jdt.ui.enable.visibility.order".equals(property)) {
            this.fSortByVisibility = this.fPreferenceStore.getBoolean("org.eclipse.jdt.ui.enable.visibility.order");
        }
    }

    public int getCategoryIndex(int kind) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[kind];
    }

    private int[] getCategoryOffsets() {
        int[] offsets = new int[9];
        IPreferenceStore store = this.fPreferenceStore;
        String key = "outlinesortoption";
        boolean success = this.fillCategoryOffsetsFromPreferenceString(store.getString(key), offsets);
        if (!success) {
            store.setToDefault(key);
            this.fillCategoryOffsetsFromPreferenceString(store.getDefaultString(key), offsets);
        }
        return offsets;
    }

    private boolean fillCategoryOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        offsets[8] = i++;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("T".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("M".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if ("F".equals(token)) {
                offsets[3] = i++;
                continue;
            }
            if ("I".equals(token)) {
                offsets[4] = i++;
                continue;
            }
            if ("SF".equals(token)) {
                offsets[5] = i++;
                continue;
            }
            if ("SI".equals(token)) {
                offsets[6] = i++;
                continue;
            }
            if ("SM".equals(token)) {
                offsets[7] = i++;
                continue;
            }
            if (!"C".equals(token)) continue;
            offsets[1] = i++;
        }
        return i == 9;
    }

    public boolean isSortByVisibility() {
        return this.fSortByVisibility;
    }

    public int getVisibilityIndex(int modifierFlags) {
        if (this.fVisibilityOffsets == null) {
            this.fVisibilityOffsets = this.getVisibilityOffsets();
        }
        int kind = 3;
        if (Flags.isPublic(modifierFlags)) {
            kind = 0;
        } else if (Flags.isProtected(modifierFlags)) {
            kind = 2;
        } else if (Flags.isPrivate(modifierFlags)) {
            kind = 1;
        }
        return this.fVisibilityOffsets[kind];
    }

    private int[] getVisibilityOffsets() {
        int[] offsets = new int[4];
        IPreferenceStore store = this.fPreferenceStore;
        String key = "org.eclipse.jdt.ui.visibility.order";
        boolean success = this.fillVisibilityOffsetsFromPreferenceString(store.getString(key), offsets);
        if (!success) {
            store.setToDefault(key);
            this.fillVisibilityOffsetsFromPreferenceString(store.getDefaultString(key), offsets);
        }
        return offsets;
    }

    private boolean fillVisibilityOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("B".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("V".equals(token)) {
                offsets[1] = i++;
                continue;
            }
            if ("R".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if (!"D".equals(token)) continue;
            offsets[3] = i++;
        }
        return i == 4;
    }
}

