/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.IndentAction;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.text.java.JavaFormattingContext;
import org.eclipse.jdt.ui.cleanup.ICleanUpConfigurationUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpPreview
extends JavaPreview {
    private ICleanUpConfigurationUI fPage;
    private boolean fFormat;
    private boolean fCorrectIndentation;

    public CleanUpPreview(Composite parent, ICleanUpConfigurationUI page) {
        super(JavaCore.getDefaultOptions(), parent);
        this.fPage = page;
        this.fFormat = false;
    }

    public void setFormat(boolean enable) {
        this.fFormat = enable;
    }

    public void setCorrectIndentation(boolean enabled) {
        this.fCorrectIndentation = enabled;
    }

    @Override
    protected void doFormatPreview() {
        this.format(this.fPage.getPreview());
    }

    private void format(String text) {
        block15: {
            if (text == null) {
                this.fPreviewDocument.set("");
                return;
            }
            this.fPreviewDocument.set(text);
            if (!this.fFormat) {
                if (!this.fCorrectIndentation) {
                    return;
                }
                this.fSourceViewer.setRedraw(false);
                try {
                    try {
                        IndentAction.indent((IDocument)this.fPreviewDocument, null);
                    }
                    catch (BadLocationException e) {
                        JavaPlugin.log(e);
                        this.fSourceViewer.setRedraw(true);
                    }
                }
                finally {
                    this.fSourceViewer.setRedraw(true);
                }
                return;
            }
            this.fSourceViewer.setRedraw(false);
            JavaFormattingContext context = new JavaFormattingContext();
            try {
                try {
                    IContentFormatter formatter = this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer);
                    if (formatter instanceof IContentFormatterExtension) {
                        IContentFormatterExtension extension = (IContentFormatterExtension)formatter;
                        context.setProperty("formatting.context.preferences", JavaCore.getOptions());
                        context.setProperty("formatting.context.document", true);
                        extension.format((IDocument)this.fPreviewDocument, (IFormattingContext)context);
                        break block15;
                    }
                    formatter.format((IDocument)this.fPreviewDocument, (IRegion)new Region(0, this.fPreviewDocument.getLength()));
                }
                catch (Exception e) {
                    Status status = new Status(4, JavaPlugin.getPluginId(), 10001, MultiFixMessages.CleanUpRefactoringWizard_formatterException_errorMessage, e);
                    JavaPlugin.log(status);
                    context.dispose();
                    this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                context.dispose();
                this.fSourceViewer.setRedraw(true);
            }
        }
    }

    @Override
    public void setWorkingValues(Map<String, String> workingValues) {
    }
}

