/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceFactoryRefactoring;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class IntroduceFactoryInputPage
extends UserInputWizardPage {
    private Text fMethodName;
    private RefactoringStatus fMethodNameStatus;
    private RefactoringStatus fDestinationStatus;

    public IntroduceFactoryInputPage(String name) {
        super(name);
    }

    private Text createTextInputField(Composite result) {
        Text textField = new Text(result, 18436);
        textField.selectAll();
        TextFieldNavigationHandler.install(textField);
        return textField;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label methNameLabel = new Label(result, 0);
        methNameLabel.setText(RefactoringMessages.IntroduceFactoryInputPage_method_name);
        this.fMethodName = this.createTextInputField(result);
        GridData gd = new GridData(768);
        this.fMethodName.setLayoutData((Object)gd);
        this.fMethodName.setText(this.getUseFactoryRefactoring().getNewMethodName());
        Label factoryTypeLabel = new Label(result, 0);
        factoryTypeLabel.setText(RefactoringMessages.IntroduceFactoryInputPage_factoryClassLabel);
        Composite inner = new Composite(result, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerLayout.numColumns = 2;
        inner.setLayout((Layout)innerLayout);
        inner.setLayoutData((Object)new GridData(768));
        final Text factoryTypeName = this.createTextInputField(inner);
        factoryTypeName.setLayoutData((Object)new GridData(768));
        Button browseTypes = new Button(inner, 8);
        browseTypes.setText(RefactoringMessages.IntroduceFactoryInputPage_browseLabel);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.widthHint = SWTUtil.getButtonWidthHint(browseTypes);
        browseTypes.setLayoutData((Object)gd);
        final Button protectCtorCB = new Button(result, 32);
        protectCtorCB.setText(RefactoringMessages.IntroduceFactoryInputPage_protectConstructorLabel);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        protectCtorCB.setLayoutData((Object)gd);
        this.fMethodName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IntroduceFactoryInputPage.this.fMethodNameStatus = IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setNewMethodName(IntroduceFactoryInputPage.this.fMethodName.getText());
                IntroduceFactoryInputPage.this.validateInput(true);
            }
        });
        protectCtorCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = protectCtorCB.getSelection();
                IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setProtectConstructor(isChecked);
            }
        });
        factoryTypeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IntroduceFactoryInputPage.this.fDestinationStatus = IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setFactoryClass(factoryTypeName.getText());
                IntroduceFactoryInputPage.this.validateInput(false);
            }
        });
        browseTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType factoryType = IntroduceFactoryInputPage.this.chooseFactoryClass();
                if (factoryType == null) {
                    return;
                }
                RefactoringStatus status = IntroduceFactoryInputPage.this.getUseFactoryRefactoring().setFactoryClass(factoryType.getFullyQualifiedName());
                boolean nameOk = status.isOK();
                factoryTypeName.setText(factoryType.getFullyQualifiedName());
                IntroduceFactoryInputPage.this.setPageComplete(nameOk);
                IntroduceFactoryInputPage.this.setErrorMessage(nameOk ? "" : status.getMessageMatchingSeverity(3));
            }
        });
        if (this.getUseFactoryRefactoring().canProtectConstructor()) {
            protectCtorCB.setSelection(true);
        } else {
            protectCtorCB.setSelection(false);
            protectCtorCB.setEnabled(false);
            this.getUseFactoryRefactoring().setProtectConstructor(false);
        }
        factoryTypeName.setText(this.getUseFactoryRefactoring().getFactoryClassName());
        this.fMethodNameStatus = this.getUseFactoryRefactoring().setNewMethodName(this.getUseFactoryRefactoring().getNewMethodName());
        this.validateInput(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.introduce_factory_wizard_page_context");
    }

    private IType chooseFactoryClass() {
        IJavaProject proj = this.getUseFactoryRefactoring().getProject();
        if (proj == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{proj};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle(RefactoringMessages.IntroduceFactoryInputPage_chooseFactoryClass_title);
        dialog.setMessage(RefactoringMessages.IntroduceFactoryInputPage_chooseFactoryClass_message);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IntroduceFactoryRefactoring getUseFactoryRefactoring() {
        return (IntroduceFactoryRefactoring)this.getRefactoring();
    }

    private void validateInput(boolean methodName) {
        RefactoringStatus merged = new RefactoringStatus();
        if (this.fMethodNameStatus != null && (methodName || this.fMethodNameStatus.hasError())) {
            merged.merge(this.fMethodNameStatus);
        }
        if (this.fDestinationStatus != null && (!methodName || this.fDestinationStatus.hasError())) {
            merged.merge(this.fDestinationStatus);
        }
        this.setPageComplete(!merged.hasError());
        int severity = merged.getSeverity();
        String message = merged.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }
}

