/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.jdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RefactoringExecutionHelper {
    private final Refactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fStopSeverity;
    private final int fSaveMode;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSeverity, int saveMode, Shell parent, IRunnableContext context) {
        Assert.isNotNull(refactoring);
        Assert.isNotNull(parent);
        Assert.isNotNull(context);
        this.fRefactoring = refactoring;
        this.fStopSeverity = stopSeverity;
        this.fParent = parent;
        this.fExecContext = context;
        this.fSaveMode = saveMode;
    }

    public void perform(boolean fork, boolean cancelable) throws InterruptedException, InvocationTargetException {
        this.perform(fork, false, cancelable);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(boolean fork, boolean forkChangeExecution, boolean cancelable) throws InterruptedException, InvocationTargetException {
        void var5_7;
        Assert.isTrue(Display.getCurrent() != null);
        final IJobManager manager = Job.getJobManager();
        if (this.fRefactoring instanceof IScheduledRefactoring) {
            ISchedulingRule iSchedulingRule = ((IScheduledRefactoring)this.fRefactoring).getSchedulingRule();
        } else {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        try {
            try {
                Runnable r = new Runnable((ISchedulingRule)var5_7){
                    private final /* synthetic */ ISchedulingRule val$rule;
                    {
                        this.val$rule = iSchedulingRule;
                    }

                    public void run() {
                        manager.beginRule(this.val$rule, null);
                    }
                };
                BusyIndicator.showWhile((Display)this.fParent.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(this.fSaveMode);
            if (!saveHelper.saveEditors(this.fParent)) {
                throw new InterruptedException();
            }
            Operation op = new Operation(fork, forkChangeExecution);
            this.fRefactoring.setValidationContext((Object)this.fParent);
            try {
                try {
                    RefactoringStatus validationStatus;
                    this.fExecContext.run(fork, cancelable, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, (ISchedulingRule)var5_7, true));
                    if (fork && !forkChangeExecution && op.fPerformChangeOperation != null) {
                        this.fExecContext.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)op.fPerformChangeOperation, (ISchedulingRule)var5_7, true));
                    }
                    if (op.fPerformChangeOperation == null || (validationStatus = op.fPerformChangeOperation.getValidationStatus()) == null || !validationStatus.hasFatalError()) return;
                    MessageDialog.openError((Shell)this.fParent, (String)this.fRefactoring.getName(), (String)Messages.format(RefactoringMessages.RefactoringExecutionHelper_cannot_execute, validationStatus.getMessageMatchingSeverity(4)));
                    throw new InterruptedException();
                }
                catch (InvocationTargetException e) {
                    PerformChangeOperation pco = op.fPerformChangeOperation;
                    if (pco == null || !pco.changeExecutionFailed()) throw e;
                    ChangeExceptionHandler handler = new ChangeExceptionHandler(this.fParent, this.fRefactoring);
                    Throwable inner = e.getTargetException();
                    if (inner instanceof RuntimeException) {
                        handler.handle(pco.getChange(), (RuntimeException)inner);
                    } else {
                        if (!(inner instanceof CoreException)) throw e;
                        handler.handle(pco.getChange(), (CoreException)inner);
                    }
                    saveHelper.triggerIncrementalBuild();
                    return;
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
            finally {
                saveHelper.triggerIncrementalBuild();
            }
        }
        finally {
            manager.endRule((ISchedulingRule)var5_7);
            this.fRefactoring.setValidationContext(null);
        }
    }

    private class Operation
    implements IWorkspaceRunnable {
        public Change fChange;
        public PerformChangeOperation fPerformChangeOperation;
        private final boolean fForked;
        private final boolean fForkChangeExecution;

        public Operation(boolean forked, boolean forkChangeExecution) {
            this.fForked = forked;
            this.fForkChangeExecution = forkChangeExecution;
        }

        public void run(IProgressMonitor pm) throws CoreException {
            try {
                pm.beginTask("", this.fForked && !this.fForkChangeExecution ? 7 : 11);
                pm.subTask("");
                final RefactoringStatus status = RefactoringExecutionHelper.this.fRefactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                if (status.getSeverity() >= RefactoringExecutionHelper.this.fStopSeverity) {
                    final boolean[] canceled = new boolean[1];
                    if (this.fForked) {
                        RefactoringExecutionHelper.this.fParent.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                canceled[0] = Operation.this.showStatusDialog(status);
                            }
                        });
                    } else {
                        canceled[0] = this.showStatusDialog(status);
                    }
                    if (canceled[0]) {
                        throw new OperationCanceledException();
                    }
                }
                this.fChange = RefactoringExecutionHelper.this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                this.fChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                this.fPerformChangeOperation = new PerformChangeOperation(this.fChange);
                this.fPerformChangeOperation.setUndoManager(RefactoringCore.getUndoManager(), RefactoringExecutionHelper.this.fRefactoring.getName());
                if (RefactoringExecutionHelper.this.fRefactoring instanceof IScheduledRefactoring) {
                    this.fPerformChangeOperation.setSchedulingRule(((IScheduledRefactoring)RefactoringExecutionHelper.this.fRefactoring).getSchedulingRule());
                }
                if (!this.fForked || this.fForkChangeExecution) {
                    this.fPerformChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                }
            }
            finally {
                pm.done();
            }
        }

        private boolean showStatusDialog(RefactoringStatus status) {
            Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)RefactoringExecutionHelper.this.fParent, (String)RefactoringExecutionHelper.this.fRefactoring.getName(), (boolean)false);
            return dialog.open() == 1;
        }
    }
}

