/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.code;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class InlineMethodInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "InlineMethodInputPage";
    private static final String DESCRIPTION = RefactoringMessages.InlineMethodInputPage_description;
    private InlineMethodRefactoring fRefactoring;
    private Button fRemove;

    public InlineMethodInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_CU);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fRefactoring = (InlineMethodRefactoring)this.getRefactoring();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        GridData gd = null;
        boolean all = this.fRefactoring.getInitialMode() == InlineMethodRefactoring.Mode.INLINE_ALL;
        Label label = new Label(result, 0);
        String methodLabel = JavaElementLabels.getElementLabel(this.fRefactoring.getMethod(), JavaElementLabels.ALL_DEFAULT | 0x80L);
        label.setText(Messages.format(RefactoringMessages.InlineMethodInputPage_inline_method, methodLabel));
        label.setLayoutData((Object)new GridData(768));
        Composite separator = new Composite(result, 0);
        separator.setLayoutData((Object)new GridData(0, 0));
        Button radioAll = new Button(result, 16);
        radioAll.setLayoutData((Object)new GridData(768));
        radioAll.setText(RefactoringMessages.InlineMethodInputPage_all_invocations);
        radioAll.setSelection(all);
        radioAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InlineMethodInputPage.this.fRemove.setEnabled(InlineMethodInputPage.this.fRefactoring.canEnableDeleteSource());
                if (((Button)event.widget).getSelection()) {
                    InlineMethodInputPage.this.changeRefactoring(InlineMethodRefactoring.Mode.INLINE_ALL);
                }
            }
        });
        this.fRemove = new Button(result, 32);
        gd = new GridData(768);
        gd.horizontalIndent = this.convertWidthInCharsToPixels(3);
        this.fRemove.setLayoutData((Object)gd);
        this.fRemove.setText(RefactoringMessages.InlineMethodInputPage_delete_declaration);
        this.fRemove.setEnabled(all && this.fRefactoring.canEnableDeleteSource());
        this.fRemove.setSelection(this.fRefactoring.canEnableDeleteSource());
        this.fRefactoring.setDeleteSource(this.fRefactoring.canEnableDeleteSource());
        this.fRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineMethodInputPage.this.fRefactoring.setDeleteSource(((Button)e.widget).getSelection());
            }
        });
        Button radioSelected = new Button(result, 16);
        radioSelected.setLayoutData((Object)new GridData(768));
        radioSelected.setText(RefactoringMessages.InlineMethodInputPage_only_selected);
        radioSelected.setSelection(!all);
        if (all) {
            radioSelected.setEnabled(false);
            radioAll.setFocus();
        } else {
            radioSelected.setFocus();
        }
        radioSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InlineMethodInputPage.this.fRemove.setEnabled(false);
                if (((Button)event.widget).getSelection()) {
                    InlineMethodInputPage.this.changeRefactoring(InlineMethodRefactoring.Mode.INLINE_SINGLE);
                }
            }
        });
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.inline_method_wizard_page_context");
    }

    private void changeRefactoring(InlineMethodRefactoring.Mode mode) {
        RefactoringStatus status;
        try {
            status = this.fRefactoring.setCurrentMode(mode);
        }
        catch (JavaModelException e) {
            status = RefactoringStatus.createFatalErrorStatus((String)e.getMessage());
        }
        this.setPageComplete(status);
    }
}

