/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class CUPositionCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private static final ImageDescriptorRegistry IMAGE_DESC_REGISTRY = JavaPlugin.getImageDescriptorRegistry();
    private String fErrorMessage;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private CompletionContextRequestor fCompletionContextRequestor;
    private CUPositionCompletionRequestor fCompletionRequestor;

    public CUPositionCompletionProcessor(CUPositionCompletionRequestor completionRequestor) {
        this.fCompletionRequestor = completionRequestor;
        this.fComparator = new CompletionProposalComparator();
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = triggers.toCharArray();
    }

    public void setCompletionContext(ICompilationUnit cuHandle, String beforeString, String afterString) {
        this.fCompletionContextRequestor = new CompletionContextRequestor(cuHandle, beforeString, afterString){
            final StubTypeContext fStubTypeContext;
            {
                this.fStubTypeContext = new StubTypeContext(iCompilationUnit, string, string2);
            }

            public StubTypeContext getStubTypeContext() {
                return this.fStubTypeContext;
            }
        };
    }

    public void setCompletionContextRequestor(CompletionContextRequestor completionContextRequestor) {
        this.fCompletionContextRequestor = completionContextRequestor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue(false, "ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue(false, "ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        if (this.fCompletionContextRequestor.getOriginalCu() == null) {
            return null;
        }
        String input = contentAssistSubjectControl.getDocument().get();
        if (documentOffset == 0) {
            return null;
        }
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(documentOffset, input);
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private ICompletionProposal[] internalComputeCompletionProposals(int documentOffset, String input) {
        String cuString = String.valueOf(this.fCompletionContextRequestor.getBeforeString()) + input + this.fCompletionContextRequestor.getAfterString();
        ICompilationUnit cu = null;
        try {
            cu = this.fCompletionContextRequestor.getOriginalCu().getWorkingCopy(new WorkingCopyOwner(){}, new NullProgressMonitor());
            cu.getBuffer().setContents(cuString);
            int cuPrefixLength = this.fCompletionContextRequestor.getBeforeString().length();
            this.fCompletionRequestor.setOffsetReduction(cuPrefixLength);
            cu.codeComplete(cuPrefixLength + documentOffset, this.fCompletionRequestor);
            ICompletionProposal[] proposals = this.fCompletionRequestor.getResults();
            if (proposals.length == 0) {
                String errorMsg = this.fCompletionRequestor.getErrorMessage();
                if (errorMsg == null || errorMsg.trim().length() == 0) {
                    errorMsg = RefactoringMessages.JavaTypeCompletionProcessor_no_completion;
                }
                this.fErrorMessage = errorMsg;
            } else {
                this.fErrorMessage = this.fCompletionRequestor.getErrorMessage();
            }
            ICompletionProposal[] iCompletionProposalArray = proposals;
            return iCompletionProposalArray;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
        finally {
            try {
                if (cu != null) {
                    cu.discardWorkingCopy();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    protected static abstract class CUPositionCompletionRequestor
    extends CompletionRequestor {
        public static final char[] TRIGGER_CHARACTERS = new char[]{'.'};
        private int fOffsetReduction;
        private List<JavaCompletionProposal> fProposals;
        private String fErrorMessage2;

        protected CUPositionCompletionRequestor() {
        }

        private void setOffsetReduction(int offsetReduction) {
            this.fOffsetReduction = offsetReduction;
            this.fProposals = new ArrayList<JavaCompletionProposal>();
        }

        public final void completionFailure(IProblem error) {
            this.fErrorMessage2 = error.getMessage();
        }

        public final JavaCompletionProposal[] getResults() {
            return this.fProposals.toArray(new JavaCompletionProposal[this.fProposals.size()]);
        }

        public final String getErrorMessage() {
            return this.fErrorMessage2;
        }

        protected final void addAdjustedCompletion(String name, String completion, int start, int end, int relevance, ImageDescriptor descriptor) {
            JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(completion, start - this.fOffsetReduction, end - start, CUPositionCompletionRequestor.getImage(descriptor), new StyledString(name), relevance);
            javaCompletionProposal.setTriggerCharacters(TRIGGER_CHARACTERS);
            this.fProposals.add(javaCompletionProposal);
        }

        protected final void addAdjustedTypeCompletion(String name, String completion, int start, int end, int relevance, ImageDescriptor descriptor, String fullyQualifiedName) {
            String replacementString = fullyQualifiedName == null || completion.length() == 0 ? completion : fullyQualifiedName;
            int replacementOffset = start - this.fOffsetReduction;
            int replacementLength = end - start;
            JavaTypeCompletionProposal javaCompletionProposal = new JavaTypeCompletionProposal(replacementString, null, replacementOffset, replacementLength, CUPositionCompletionRequestor.getImage(descriptor), new StyledString(name), relevance, fullyQualifiedName);
            javaCompletionProposal.setTriggerCharacters(TRIGGER_CHARACTERS);
            this.fProposals.add(javaCompletionProposal);
        }

        private static Image getImage(ImageDescriptor descriptor) {
            return descriptor == null ? null : IMAGE_DESC_REGISTRY.get(descriptor);
        }
    }
}

