/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultiStateCellEditor
extends CellEditor {
    private int fValue;
    private final int fStateCount;

    public MultiStateCellEditor(Composite parent, int stateCount, int initialValue) {
        super(parent);
        Assert.isTrue(stateCount > 1, "incorrect state count");
        this.fStateCount = stateCount;
        Assert.isTrue(initialValue >= 0 && initialValue < stateCount, "incorrect initial value");
        this.fValue = initialValue;
        this.setValueValid(true);
    }

    public void activate() {
        this.fValue = MultiStateCellEditor.getNextValue(this.fStateCount, this.fValue);
        this.fireApplyEditorValue();
    }

    public static int getNextValue(int stateCount, int currentValue) {
        Assert.isTrue(stateCount > 1, "incorrect state count");
        Assert.isTrue(currentValue >= 0 && currentValue < stateCount, "incorrect initial value");
        return (currentValue + 1) % stateCount;
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected Object doGetValue() {
        return new Integer(this.fValue);
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        Assert.isTrue(value instanceof Integer, "value must be Integer");
        this.fValue = (Integer)value;
        Assert.isTrue(this.fValue >= 0 && this.fValue < this.fStateCount, "invalid value");
    }
}

