/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.PackageFragmentSelection;
import org.eclipse.jdt.internal.ui.refactoring.nls.PackageSelectionStringButtonAdapter;
import org.eclipse.jdt.internal.ui.refactoring.nls.SourceFolderSelectionDialogButtonField;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

class SourceFirstPackageSelectionDialogField {
    private SourceFolderSelectionDialogButtonField fSourceFolderSelection;
    private PackageFragmentSelection fPackageSelection;
    private Shell fShell;

    public SourceFirstPackageSelectionDialogField(String sourceLabel, String packageLabel, String browseLabel1, String browseLabel2, String statusHint, String dialogTitle, String dialogMessage, String dialogEmptyMessage, ICompilationUnit cu, IDialogFieldListener updateListener, IPackageFragment fragment) {
        this.fSourceFolderSelection = new SourceFolderSelectionDialogButtonField(sourceLabel, browseLabel1, new SFStringButtonAdapter());
        this.fPackageSelection = new PackageFragmentSelection(this, packageLabel, browseLabel2, statusHint, new PackageSelectionStringButtonAdapter(this, dialogTitle, dialogMessage, dialogEmptyMessage));
        this.fPackageSelection.setDialogFieldListener(new PackageSelectionDialogFieldListener());
        this.fSourceFolderSelection.setSourceChangeListener(this.fPackageSelection);
        this.setDefaults(fragment, cu);
        this.fPackageSelection.setUpdateListener(updateListener);
        this.fSourceFolderSelection.setUpdateListener(updateListener);
    }

    private void setDefaults(IPackageFragment fragment, ICompilationUnit cu) {
        IParent element = fragment;
        if (element == null) {
            element = cu;
        }
        this.fSourceFolderSelection.setRoot(this.searchSourcePackageFragmentRoot((IJavaElement)((Object)element)));
        this.fPackageSelection.setPackageFragment(this.searchPackageFragment((IJavaElement)((Object)element)));
    }

    private IPackageFragment searchPackageFragment(IJavaElement jElement) {
        return (IPackageFragment)jElement.getAncestor(4);
    }

    private IPackageFragmentRoot searchSourcePackageFragmentRoot(IJavaElement jElement) {
        IJavaElement parent = jElement.getAncestor(3);
        if (parent == null) {
            return null;
        }
        IPackageFragmentRoot res = (IPackageFragmentRoot)parent;
        try {
            if (res.getKind() == 1) {
                return res;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement initElement) {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NLSUIMessages.SourceFirstPackageSelectionDialogField_ChooseSourceContainerDialog_title);
        dialog.setMessage(NLSUIMessages.SourceFirstPackageSelectionDialogField_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()));
        dialog.setInitialSelection((Object)initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot(jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    public IPackageFragment getSelected() {
        IPackageFragment res = this.fPackageSelection.getPackageFragment();
        return res;
    }

    public IPackageFragmentRoot getSelectedFragmentRoot() {
        return this.fSourceFolderSelection.getRoot();
    }

    public void setSelected(IPackageFragment newSelection) {
        this.fPackageSelection.setPackageFragment(newSelection);
        this.fSourceFolderSelection.setRoot(this.searchSourcePackageFragmentRoot(newSelection));
    }

    public void createControl(Composite parent, int nOfColumns, int textWidth) {
        this.fShell = parent.getShell();
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSourceFolderSelection.doFillIntoGrid(parent, nOfColumns, textWidth);
        LayoutUtil.setWidthHint((Control)this.fSourceFolderSelection.getTextControl(null), converter.convertWidthInCharsToPixels(60));
        this.fPackageSelection.doFillIntoGrid(parent, nOfColumns, textWidth);
        LayoutUtil.setWidthHint((Control)this.fPackageSelection.getTextControl(null), converter.convertWidthInCharsToPixels(60));
    }

    class PackageSelectionDialogFieldListener
    implements IDialogFieldListener {
        PackageSelectionDialogFieldListener() {
        }

        public void dialogFieldChanged(DialogField field) {
            String packName = SourceFirstPackageSelectionDialogField.this.fPackageSelection.getText();
            if (packName.length() == 0) {
                SourceFirstPackageSelectionDialogField.this.fPackageSelection.setStatus(NLSUIMessages.NLSAccessorConfigurationDialog_default);
            } else {
                SourceFirstPackageSelectionDialogField.this.fPackageSelection.setStatus("");
            }
        }
    }

    class SFStringButtonAdapter
    implements IStringButtonAdapter {
        SFStringButtonAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPackageFragmentRoot newSourceContainer = SourceFirstPackageSelectionDialogField.this.chooseSourceContainer(SourceFirstPackageSelectionDialogField.this.fSourceFolderSelection.getRoot());
            if (newSourceContainer != null) {
                SourceFirstPackageSelectionDialogField.this.fSourceFolderSelection.setRoot(newSourceContainer);
            }
        }
    }
}

