/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.refactoring.TypedSource;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyToClipboardAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private boolean fAutoRepeatOnFailure = false;

    public CopyToClipboardAction(IWorkbenchSite site) {
        this(site, (Clipboard)null);
    }

    public CopyToClipboardAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        this.setText(ReorgMessages.CopyToClipboardAction_text);
        this.setDescription(ReorgMessages.CopyToClipboardAction_description);
        this.fClipboard = clipboard;
        ISharedImages workbenchImages = CopyToClipboardAction.getWorkbenchSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.copy_action");
    }

    public void setAutoRepeatOnFailure(boolean autorepeatOnFailure) {
        this.fAutoRepeatOnFailure = autorepeatOnFailure;
    }

    private static ISharedImages getWorkbenchSharedImages() {
        return JavaPlugin.getDefault().getWorkbench().getSharedImages();
    }

    public void selectionChanged(IStructuredSelection selection) {
        List elements = selection.toList();
        IResource[] resources = ReorgUtils.getResources(elements);
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
        IJarEntryResource[] jarEntryResources = ReorgUtils.getJarEntryResources(elements);
        if (elements.size() != resources.length + javaElements.length + jarEntryResources.length) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.canEnable(resources, javaElements, jarEntryResources));
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            IJarEntryResource[] jarEntryResources = ReorgUtils.getJarEntryResources(elements);
            if (elements.size() == resources.length + javaElements.length + jarEntryResources.length && this.canEnable(resources, javaElements, jarEntryResources)) {
                this.doRun(resources, javaElements, jarEntryResources);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ReorgMessages.CopyToClipboardAction_2, ReorgMessages.CopyToClipboardAction_3);
        }
    }

    private void doRun(IResource[] resources, IJavaElement[] javaElements, IJarEntryResource[] jarEntryResources) throws CoreException {
        ClipboardCopier copier = new ClipboardCopier(resources, javaElements, jarEntryResources, this.getShell(), this.fAutoRepeatOnFailure);
        if (this.fClipboard != null) {
            copier.copyToClipboard(this.fClipboard);
        } else {
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            try {
                copier.copyToClipboard(clipboard);
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private boolean canEnable(IResource[] resources, IJavaElement[] javaElements, IJarEntryResource[] jarEntryResources) {
        return new CopyToClipboardEnablementPolicy(resources, javaElements, jarEntryResources).canEnable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClipboardCopier {
        private final boolean fAutoRepeatOnFailure;
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;
        private final IJarEntryResource[] fJarEntryResources;
        private final Shell fShell;
        private final ILabelProvider fLabelProvider;

        private ClipboardCopier(IResource[] resources, IJavaElement[] javaElements, IJarEntryResource[] jarEntryResources, Shell shell, boolean autoRepeatOnFailure) {
            Assert.isNotNull(resources);
            Assert.isNotNull(javaElements);
            Assert.isNotNull(jarEntryResources);
            Assert.isNotNull(shell);
            this.fResources = resources;
            this.fJavaElements = javaElements;
            this.fJarEntryResources = jarEntryResources;
            this.fShell = shell;
            this.fLabelProvider = ClipboardCopier.createLabelProvider();
            this.fAutoRepeatOnFailure = autoRepeatOnFailure;
        }

        public void copyToClipboard(Clipboard clipboard) throws CoreException {
            StringBuffer namesBuf = new StringBuffer();
            int countOfNonJarResources = this.fResources.length + this.fJavaElements.length;
            this.processJarEntryResources(namesBuf);
            if (countOfNonJarResources == 0) {
                this.copyToClipboard(this.fResources, new String[0], namesBuf.toString(), this.fJavaElements, new TypedSource[0], 0, clipboard);
            } else {
                HashSet<String> fileNames = new HashSet<String>(countOfNonJarResources);
                this.processResources(fileNames, namesBuf);
                this.processJavaElements(fileNames, namesBuf);
                IJavaElement[] mainTypes = ReorgUtils.getMainTypes(this.fJavaElements);
                IJavaElement[] cusOfMainTypes = ReorgUtils.getCompilationUnits(mainTypes);
                IResource[] resourcesOfMainTypes = ReorgUtils.getResources(cusOfMainTypes);
                ClipboardCopier.addFileNames(fileNames, resourcesOfMainTypes);
                IResource[] cuResources = ReorgUtils.getResources(ClipboardCopier.getCompilationUnits(this.fJavaElements));
                ClipboardCopier.addFileNames(fileNames, cuResources);
                IResource[] resourcesForClipboard = ReorgUtils.union(this.fResources, ReorgUtils.union(cuResources, resourcesOfMainTypes));
                IJavaElement[] javaElementsForClipboard = ReorgUtils.union(this.fJavaElements, cusOfMainTypes);
                TypedSource[] typedSources = TypedSource.createTypedSources(javaElementsForClipboard);
                String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
                this.copyToClipboard(resourcesForClipboard, fileNameArray, namesBuf.toString(), javaElementsForClipboard, typedSources, 0, clipboard);
            }
        }

        private static IJavaElement[] getCompilationUnits(IJavaElement[] javaElements) {
            List<?> cus = ReorgUtils.getElementsOfType(javaElements, 5);
            return cus.toArray(new ICompilationUnit[cus.size()]);
        }

        private void processResources(Set<String> fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fResources.length) {
                IResource resource = this.fResources[i];
                ClipboardCopier.addFileName(fileNames, resource);
                if (namesBuf.length() > 0 || i > 0) {
                    namesBuf.append(System.getProperty("line.separator"));
                }
                namesBuf.append(this.getName(resource));
                ++i;
            }
        }

        private void processJavaElements(Set<String> fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fJavaElements.length) {
                IJavaElement element = this.fJavaElements[i];
                switch (element.getElementType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ClipboardCopier.addFileName(fileNames, ReorgUtils.getResource(element));
                        break;
                    }
                }
                if (namesBuf.length() > 0 || i > 0) {
                    namesBuf.append(System.getProperty("line.separator"));
                }
                namesBuf.append(this.getName(element));
                ++i;
            }
        }

        private void processJarEntryResources(StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fJarEntryResources.length) {
                if (namesBuf.length() > 0 || i > 0) {
                    namesBuf.append(System.getProperty("line.separator"));
                }
                namesBuf.append(this.getName(this.fJarEntryResources[i]));
                ++i;
            }
        }

        private static void addFileNames(Set<String> fileName, IResource[] resources) {
            int i = 0;
            while (i < resources.length) {
                ClipboardCopier.addFileName(fileName, resources[i]);
                ++i;
            }
        }

        private static void addFileName(Set<String> fileName, IResource resource) {
            if (resource == null) {
                return;
            }
            IPath location = resource.getLocation();
            if (location != null) {
                fileName.add(location.toOSString());
            }
        }

        private void copyToClipboard(IResource[] resources, String[] fileNames, String names, IJavaElement[] javaElements, TypedSource[] typedSources, int repeat, Clipboard clipboard) {
            block6: {
                try {
                    clipboard.setContents(ClipboardCopier.createDataArray(resources, javaElements, fileNames, names, typedSources), ClipboardCopier.createDataTypeArray(resources, javaElements, fileNames, typedSources));
                }
                catch (SWTError e) {
                    if (e.code != 2002 || repeat >= 10) {
                        throw e;
                    }
                    if (this.fAutoRepeatOnFailure) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.fAutoRepeatOnFailure && !MessageDialog.openQuestion((Shell)this.fShell, (String)ReorgMessages.CopyToClipboardAction_4, (String)ReorgMessages.CopyToClipboardAction_5)) break block6;
                    this.copyToClipboard(resources, fileNames, names, javaElements, typedSources, repeat + 1, clipboard);
                }
            }
        }

        private static Transfer[] createDataTypeArray(IResource[] resources, IJavaElement[] javaElements, String[] fileNames, TypedSource[] typedSources) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(ResourceTransfer.getInstance());
            }
            if (javaElements.length != 0) {
                result.add((Object)JavaElementTransfer.getInstance());
            }
            if (fileNames.length != 0) {
                result.add(FileTransfer.getInstance());
            }
            if (typedSources.length != 0) {
                result.add((Object)TypedSourceTransfer.getInstance());
            }
            result.add(TextTransfer.getInstance());
            return result.toArray(new Transfer[result.size()]);
        }

        private static Object[] createDataArray(IResource[] resources, IJavaElement[] javaElements, String[] fileNames, String names, TypedSource[] typedSources) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(resources);
            }
            if (javaElements.length != 0) {
                result.add(javaElements);
            }
            if (fileNames.length != 0) {
                result.add(fileNames);
            }
            if (typedSources.length != 0) {
                result.add(typedSources);
            }
            result.add(names);
            return result.toArray();
        }

        private static ILabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(546);
        }

        private String getName(IResource resource) {
            return TextProcessor.deprocess(this.fLabelProvider.getText((Object)resource));
        }

        private String getName(IJavaElement javaElement) {
            return TextProcessor.deprocess(this.fLabelProvider.getText((Object)javaElement));
        }

        private String getName(IJarEntryResource resource) {
            return TextProcessor.deprocess(this.fLabelProvider.getText((Object)resource));
        }
    }

    private static class CopyToClipboardEnablementPolicy {
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;
        private final IJarEntryResource[] fJarEntryResources;

        public CopyToClipboardEnablementPolicy(IResource[] resources, IJavaElement[] javaElements, IJarEntryResource[] jarEntryResources) {
            Assert.isNotNull(resources);
            Assert.isNotNull(javaElements);
            Assert.isNotNull(jarEntryResources);
            this.fResources = resources;
            this.fJavaElements = javaElements;
            this.fJarEntryResources = jarEntryResources;
        }

        public boolean canEnable() {
            if (this.fResources.length + this.fJavaElements.length + this.fJarEntryResources.length == 0) {
                return false;
            }
            if (this.hasProjects() && this.hasNonProjects()) {
                return false;
            }
            if (!this.canCopyAllToClipboard()) {
                return false;
            }
            return new ParentChecker(this.fResources, this.fJavaElements, this.fJarEntryResources).haveCommonParent();
        }

        private boolean canCopyAllToClipboard() {
            int i = 0;
            while (i < this.fResources.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fResources[i])) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJavaElements.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fJavaElements[i])) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJarEntryResources.length) {
                if (this.fJarEntryResources[i] == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean canCopyToClipboard(IJavaElement element) {
            if (element == null || !element.exists()) {
                return false;
            }
            return !JavaElementUtil.isDefaultPackage(element);
        }

        private static boolean canCopyToClipboard(IResource resource) {
            return resource != null && resource.exists() && !resource.isPhantom() && resource.getType() != 8;
        }

        private boolean hasProjects() {
            int i = 0;
            while (i < this.fResources.length) {
                if (ReorgUtils.isProject(this.fResources[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJavaElements.length) {
                if (ReorgUtils.isProject(this.fJavaElements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean hasNonProjects() {
            int i = 0;
            while (i < this.fResources.length) {
                if (!ReorgUtils.isProject(this.fResources[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.fJavaElements.length) {
                if (!ReorgUtils.isProject(this.fJavaElements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

