/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewNameQueries
implements INewNameQueries {
    private static final String INVALID_NAME_NO_MESSAGE = "";
    private final Wizard fWizard;
    private final Shell fShell;

    public NewNameQueries() {
        this.fShell = null;
        this.fWizard = null;
    }

    public NewNameQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public NewNameQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue(this.fWizard == null || this.fShell == null);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public INewNameQuery createNewCompilationUnitNameQuery(ICompilationUnit cu, String initialSuggestedName) {
        Object[] keys = new String[]{BasicElementLabels.getJavaElementName(JavaCore.removeJavaLikeExtension(cu.getElementName()))};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createCompilationUnitNameValidator(cu), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewResourceNameQuery(IResource res, String initialSuggestedName) {
        Object[] keys = new String[]{BasicElementLabels.getResourceName(res)};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createResourceNameValidator(res), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewPackageNameQuery(IPackageFragment pack, String initialSuggestedName) {
        Object[] keys = new String[]{JavaElementLabels.getElementLabel(pack, JavaElementLabels.ALL_DEFAULT)};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageNameValidator(pack), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNewPackageFragmentRootNameQuery(IPackageFragmentRoot root, String initialSuggestedName) {
        Object[] keys = new String[]{JavaElementLabels.getElementLabel(root, JavaElementLabels.ALL_DEFAULT)};
        String message = Messages.format(ReorgMessages.ReorgQueries_enterNewNameQuestion, keys);
        return NewNameQueries.createStaticQuery(NewNameQueries.createPackageFragmentRootNameValidator(root), message, initialSuggestedName, this.getShell());
    }

    public INewNameQuery createNullQuery() {
        return this.createStaticQuery(null);
    }

    public INewNameQuery createStaticQuery(final String newName) {
        return new INewNameQuery(){

            public String getNewName() {
                return newName;
            }
        };
    }

    private static INewNameQuery createStaticQuery(final IInputValidator validator, final String message, final String initial, final Shell shell) {
        return new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                InputDialog dialog = new InputDialog(shell, ReorgMessages.ReorgQueries_nameConflictMessage, message, initial, validator){

                    protected Control createDialogArea(Composite parent) {
                        Control area = super.createDialogArea(parent);
                        TextFieldNavigationHandler.install(this.getText());
                        return area;
                    }
                };
                if (dialog.open() == 1) {
                    throw new OperationCanceledException();
                }
                return dialog.getValue();
            }
        };
    }

    private static IInputValidator createResourceNameValidator(final IResource res) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText) || res.getParent() == null) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (res.getParent().findMember(newText) != null) {
                    return ReorgMessages.ReorgQueries_resourceWithThisNameAlreadyExists;
                }
                if (!res.getParent().getFullPath().isValidSegment(newText)) {
                    return ReorgMessages.ReorgQueries_invalidNameMessage;
                }
                IStatus status = res.getParent().getWorkspace().validateName(newText, res.getType());
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                if (res.getName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createCompilationUnitNameValidator(final ICompilationUnit cu) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                String newCuName = JavaModelUtil.getRenamedCUName(cu, newText);
                IStatus status = JavaConventionsUtil.validateCompilationUnitName(newCuName, cu);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                RefactoringStatus refStatus = Checks.checkCompilationUnitNewName(cu, newText);
                if (refStatus.hasFatalError()) {
                    return refStatus.getMessageMatchingSeverity(4);
                }
                if (cu.getElementName().equalsIgnoreCase(newCuName)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }

    private static IInputValidator createPackageFragmentRootNameValidator(IPackageFragmentRoot root) {
        return new IInputValidator(root){
            IInputValidator resourceNameValidator;
            {
                this.resourceNameValidator = NewNameQueries.createResourceNameValidator(iPackageFragmentRoot.getResource());
            }

            public String isValid(String newText) {
                return this.resourceNameValidator.isValid(newText);
            }
        };
    }

    private static IInputValidator createPackageNameValidator(final IPackageFragment pack) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || NewNameQueries.INVALID_NAME_NO_MESSAGE.equals(newText)) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                IStatus status = JavaConventionsUtil.validatePackageName(newText, pack);
                if (status.getSeverity() == 4) {
                    return status.getMessage();
                }
                IJavaElement parent = pack.getParent();
                try {
                    if (parent instanceof IPackageFragmentRoot && !RenamePackageProcessor.isPackageNameOkInRoot(newText, (IPackageFragmentRoot)parent)) {
                        return ReorgMessages.ReorgQueries_packagewithThatNameexistsMassage;
                    }
                }
                catch (CoreException coreException) {
                    return NewNameQueries.INVALID_NAME_NO_MESSAGE;
                }
                if (pack.getElementName().equalsIgnoreCase(newText)) {
                    return ReorgMessages.ReorgQueries_resourceExistsWithDifferentCaseMassage;
                }
                return null;
            }
        };
        return validator;
    }
}

