/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyProjectAction;

public class ReorgCopyAction
extends SelectionDispatchAction {
    public ReorgCopyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.ReorgCopyAction_3);
        this.setDescription(ReorgMessages.ReorgCopyAction_4);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.copy_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block7: {
            if (!selection.isEmpty()) {
                if (ReorgUtils.containsOnlyProjects(selection.toList())) {
                    this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
                    return;
                }
                try {
                    List elements = selection.toList();
                    IResource[] resources = ReorgUtils.getResources(elements);
                    IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
                    if (elements.size() != resources.length + javaElements.length) {
                        this.setEnabled(false);
                        break block7;
                    }
                    this.setEnabled(RefactoringAvailabilityTester.isCopyAvailable(resources, javaElements));
                }
                catch (JavaModelException e) {
                    if (JavaModelUtil.isExceptionToBeLogged(e)) {
                        JavaPlugin.log(e);
                    }
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private CopyProjectAction createWorkbenchAction(IStructuredSelection selection) {
        CopyProjectAction action = new CopyProjectAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (RefactoringAvailabilityTester.isCopyAvailable(resources, javaElements)) {
                RefactoringExecutionStarter.startCopyRefactoring(resources, javaElements, this.getShell());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

