/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveProjectAction;

public class ReorgMoveAction
extends SelectionDispatchAction {
    public ReorgMoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.ReorgMoveAction_3);
        this.setDescription(ReorgMessages.ReorgMoveAction_4);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block7: {
            if (!selection.isEmpty()) {
                if (ReorgUtils.containsOnlyProjects(selection.toList())) {
                    this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
                    return;
                }
                try {
                    List elements = selection.toList();
                    IResource[] resources = ReorgUtils.getResources(elements);
                    IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
                    if (elements.size() != resources.length + javaElements.length) {
                        this.setEnabled(false);
                        break block7;
                    }
                    this.setEnabled(RefactoringAvailabilityTester.isMoveAvailable(resources, javaElements));
                }
                catch (JavaModelException e) {
                    if (JavaModelUtil.isExceptionToBeLogged(e)) {
                        JavaPlugin.log(e);
                    }
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private MoveProjectAction createWorkbenchAction(IStructuredSelection selection) {
        MoveProjectAction action = new MoveProjectAction((IShellProvider)this.getSite());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (RefactoringAvailabilityTester.isMoveAvailable(resources, javaElements)) {
                RefactoringExecutionStarter.startMoveRefactoring(resources, javaElements, this.getShell());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

