/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    protected static final Match[] NO_MATCHES = new Match[0];

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches((IAdaptable)editor.getEditorInput());
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches(file);
    }

    private Match[] computeContainedMatches(IAdaptable adaptable) {
        IFile file;
        IJavaElement javaElement = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
        HashSet<Match> matches = new HashSet<Match>();
        if (javaElement != null) {
            this.collectMatches(matches, javaElement);
        }
        if ((file = (IFile)adaptable.getAdapter(IFile.class)) != null) {
            this.collectMatches(matches, file);
        }
        if (!matches.isEmpty()) {
            return matches.toArray(new Match[matches.size()]);
        }
        return NO_MATCHES;
    }

    private void collectMatches(Set<Match> matches, IFile element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
    }

    private void collectMatches(Set<Match> matches, IJavaElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)((Object)element);
            try {
                IJavaElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            ICompilationUnit cu = (ICompilationUnit)javaElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getResource();
            }
            IClassFile cf = (IClassFile)javaElement.getAncestor(6);
            if (cf != null) {
                return (IFile)cf.getResource();
            }
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IJavaElement) {
            return (element = ((IJavaElement)element).getOpenable()) != null && element.equals(editor.getEditorInput().getAdapter(IJavaElement.class));
        }
        if (element instanceof IFile) {
            return element.equals(editor.getEditorInput().getAdapter(IFile.class));
        }
        return false;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

