/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementLabels;

public class PatternStrings {
    public static String getSignature(IJavaElement element) {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 9: {
                return PatternStrings.getMethodSignature((IMethod)element);
            }
            case 7: {
                return PatternStrings.getTypeSignature((IType)element);
            }
            case 8: {
                return PatternStrings.getFieldSignature((IField)element);
            }
        }
        return element.getElementName();
    }

    public static String getMethodSignature(IMethod method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JavaElementLabels.getElementLabel(method.getDeclaringType(), 0x1000000040000L));
        boolean isConstructor = method.getElementName().equals(method.getDeclaringType().getElementName());
        if (!isConstructor) {
            buffer.append('.');
        }
        buffer.append(PatternStrings.getUnqualifiedMethodSignature(method, !isConstructor));
        return buffer.toString();
    }

    private static String getUnqualifiedMethodSignature(IMethod method, boolean includeName) {
        StringBuffer buffer = new StringBuffer();
        if (includeName) {
            buffer.append(method.getElementName());
        }
        buffer.append('(');
        String[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            String typeSig = Signature.toString(types[i]);
            buffer.append(typeSig);
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getUnqualifiedMethodSignature(IMethod method) {
        return PatternStrings.getUnqualifiedMethodSignature(method, true);
    }

    public static String getTypeSignature(IType field) {
        return JavaElementLabels.getElementLabel(field, 281474979069952L);
    }

    public static String getFieldSignature(IField field) {
        return JavaElementLabels.getElementLabel(field, 65536L);
    }
}

