/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentCharacterIterator
implements CharacterIterator,
CharSequence {
    private int fIndex = -1;
    private final IDocument fDocument;
    private final int fFirst;
    private final int fLast;

    private void invariant() {
        Assert.isTrue(this.fIndex >= this.fFirst);
        Assert.isTrue(this.fIndex <= this.fLast);
    }

    public DocumentCharacterIterator(IDocument document) throws BadLocationException {
        this(document, 0);
    }

    public DocumentCharacterIterator(IDocument document, int first) throws BadLocationException {
        this(document, first, document.getLength());
    }

    public DocumentCharacterIterator(IDocument document, int first, int last) throws BadLocationException {
        if (document == null) {
            throw new NullPointerException();
        }
        if (first < 0 || first > last) {
            throw new BadLocationException();
        }
        if (last > document.getLength()) {
            throw new BadLocationException();
        }
        this.fDocument = document;
        this.fFirst = first;
        this.fLast = last;
        this.fIndex = first;
        this.invariant();
    }

    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    public char last() {
        if (this.fFirst == this.fLast) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    public char current() {
        if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
            try {
                return this.fDocument.getChar(this.fIndex);
            }
            catch (BadLocationException badLocationException) {}
        }
        return '\uffff';
    }

    public char next() {
        return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
    }

    public char previous() {
        if (this.fIndex > this.getBeginIndex()) {
            return this.setIndex(this.fIndex - 1);
        }
        return '\uffff';
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.fIndex = position;
        this.invariant();
        return this.current();
    }

    public int getBeginIndex() {
        return this.fFirst;
    }

    public int getEndIndex() {
        return this.fLast;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int length() {
        return this.getEndIndex() - this.getBeginIndex();
    }

    public char charAt(int index) {
        if (index >= 0 && index < this.length()) {
            try {
                return this.fDocument.getChar(this.getBeginIndex() + index);
            }
            catch (BadLocationException badLocationException) {
                return '\uffff';
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            return new DocumentCharacterIterator(this.fDocument, this.getBeginIndex() + start, this.getBeginIndex() + end);
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException();
        }
    }
}

