/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClasspathFixProcessorDescriptor {
    private static final String ATT_EXTENSION = "classpathFixProcessors";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String OVERRIDES = "overrides";
    private static ClasspathFixProcessorDescriptor[] fgContributedClasspathFixProcessors;
    private final IConfigurationElement fConfigurationElement;
    private ClasspathFixProcessor fProcessorInstance;
    private List<String> fOverriddenIds;
    private Boolean fStatus;

    public ClasspathFixProcessorDescriptor(IConfigurationElement element) {
        IConfigurationElement[] children;
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fStatus = null;
        if (this.fConfigurationElement.getChildren("enablement").length == 0) {
            this.fStatus = Boolean.TRUE;
        }
        if ((children = this.fConfigurationElement.getChildren(OVERRIDES)).length > 0) {
            this.fOverriddenIds = new ArrayList<String>(children.length);
            int i = 0;
            while (i < children.length) {
                this.fOverriddenIds.add(children[i].getAttribute(ID));
                ++i;
            }
        } else {
            this.fOverriddenIds = Collections.emptyList();
        }
    }

    public String getID() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public Collection<String> getOverridenIds() {
        return this.fOverriddenIds;
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            return new StatusInfo(4, "Only one < enablement > element allowed. Disabling " + this.getID());
        }
        return new StatusInfo(0, "Syntactically correct classpath fix processor");
    }

    public boolean matches(IJavaProject javaProject) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length == 1) {
            try {
                ExpressionConverter parser = ExpressionConverter.getDefault();
                Expression expression = parser.perform(children[0]);
                EvaluationContext evalContext = new EvaluationContext(null, (Object)javaProject);
                evalContext.addVariable("project", (Object)javaProject);
                evalContext.addVariable("sourceLevel", (Object)javaProject.getOption("org.eclipse.jdt.core.compiler.source", true));
                return expression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return false;
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    public ClasspathFixProcessor getProcessor(IJavaProject project) {
        if (this.matches(project)) {
            block5: {
                if (this.fProcessorInstance == null) {
                    try {
                        Object extension = this.fConfigurationElement.createExecutableExtension(CLASS);
                        if (extension instanceof ClasspathFixProcessor) {
                            this.fProcessorInstance = (ClasspathFixProcessor)extension;
                            break block5;
                        }
                        String message = "Invalid extension to classpathFixProcessors. Must extends ClasspathFixProcessor: " + this.getID();
                        JavaPlugin.log(new Status(4, "org.eclipse.jdt.ui", message));
                        this.fStatus = Boolean.FALSE;
                        return null;
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                        this.fStatus = Boolean.FALSE;
                        return null;
                    }
                }
            }
            return this.fProcessorInstance;
        }
        return null;
    }

    private static ClasspathFixProcessorDescriptor[] getCorrectionProcessors() {
        if (fgContributedClasspathFixProcessors == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jdt.ui", ATT_EXTENSION);
            ArrayList<ClasspathFixProcessorDescriptor> res = new ArrayList<ClasspathFixProcessorDescriptor>(elements.length);
            int i = 0;
            while (i < elements.length) {
                ClasspathFixProcessorDescriptor desc = new ClasspathFixProcessorDescriptor(elements[i]);
                IStatus status = desc.checkSyntax();
                if (status.isOK()) {
                    res.add(desc);
                } else {
                    JavaPlugin.log(status);
                }
                ++i;
            }
            fgContributedClasspathFixProcessors = res.toArray(new ClasspathFixProcessorDescriptor[res.size()]);
            Arrays.sort(fgContributedClasspathFixProcessors, new Comparator<ClasspathFixProcessorDescriptor>(){

                @Override
                public int compare(ClasspathFixProcessorDescriptor d1, ClasspathFixProcessorDescriptor d2) {
                    if (d1.getOverridenIds().contains(d2.getID())) {
                        return -1;
                    }
                    if (d2.getOverridenIds().contains(d1.getID())) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        return fgContributedClasspathFixProcessors;
    }

    public static ClasspathFixProcessor.ClasspathFixProposal[] getProposals(final IJavaProject project, final String missingType, final MultiStatus status) {
        final ArrayList proposals = new ArrayList();
        final HashSet overriddenIds = new HashSet();
        ClasspathFixProcessorDescriptor[] correctionProcessors = ClasspathFixProcessorDescriptor.getCorrectionProcessors();
        int i = 0;
        while (i < correctionProcessors.length) {
            ClasspathFixProcessorDescriptor curr = correctionProcessors[i];
            if (!overriddenIds.contains(curr.getID())) {
                SafeRunner.run(new ISafeRunnable(){

                    public void run() throws Exception {
                        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals;
                        ClasspathFixProcessor processor = ClasspathFixProcessorDescriptor.this.getProcessor(project);
                        if (processor != null && (fixProposals = processor.getFixImportProposals(project, missingType)) != null) {
                            int k = 0;
                            while (k < fixProposals.length) {
                                proposals.add(fixProposals[k]);
                                ++k;
                            }
                            overriddenIds.addAll(ClasspathFixProcessorDescriptor.this.getOverridenIds());
                        }
                    }

                    public void handleException(Throwable exception) {
                        if (status != null) {
                            status.merge(new Status(4, "org.eclipse.jdt.ui", 4, CorrectionMessages.ClasspathFixProcessorDescriptor_error_processing_processors, exception));
                        }
                    }
                });
            }
            ++i;
        }
        return proposals.toArray(new ClasspathFixProcessor.ClasspathFixProposal[proposals.size()]);
    }
}

