/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class SerialVersionHashOperation
extends AbstractSerialVersionOperation {
    private static final String STATIC_CLASS_INITIALIZER = "<clinit>";
    private final ICompilationUnit fCompilationUnit;

    public static Long calculateSerialVersionId(ITypeBinding typeBinding, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            IFile classfileResource = SerialVersionHashOperation.getClassfile(typeBinding);
            if (classfileResource == null) {
                return null;
            }
            InputStream contents = classfileResource.getContents();
            try {
                IClassFileReader cfReader = ToolFactory.createDefaultClassFileReader(contents, 65535);
                if (cfReader != null) {
                    Long l = SerialVersionHashOperation.calculateSerialVersionId(cfReader);
                    return l;
                }
            }
            finally {
                contents.close();
            }
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static String getClassName(char[] name) {
        return new String(name).replace('/', '.');
    }

    private static Long calculateSerialVersionId(IClassFileReader cfReader) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream doos = new DataOutputStream(os);
        doos.writeUTF(SerialVersionHashOperation.getClassName(cfReader.getClassName()));
        int mod = SerialVersionHashOperation.getClassModifiers(cfReader);
        int classModifiers = mod & 0x611;
        doos.writeInt(classModifiers);
        char[][] interfaces = SerialVersionHashOperation.getSortedInterfacesNames(cfReader);
        int i = 0;
        while (i < interfaces.length) {
            doos.writeUTF(SerialVersionHashOperation.getClassName(interfaces[i]));
            ++i;
        }
        IFieldInfo[] sortedFields = SerialVersionHashOperation.getSortedFields(cfReader);
        int i2 = 0;
        while (i2 < sortedFields.length) {
            IFieldInfo curr = sortedFields[i2];
            int flags = curr.getAccessFlags();
            if (!Flags.isPrivate(flags) || !Flags.isStatic(flags) && !Flags.isTransient(flags)) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xDF);
                doos.writeUTF(new String(curr.getDescriptor()));
            }
            ++i2;
        }
        if (SerialVersionHashOperation.hasStaticClassInitializer(cfReader)) {
            doos.writeUTF(STATIC_CLASS_INITIALIZER);
            doos.writeInt(8);
            doos.writeUTF("()V");
        }
        IMethodInfo[] sortedMethods = SerialVersionHashOperation.getSortedMethods(cfReader);
        int i3 = 0;
        while (i3 < sortedMethods.length) {
            IMethodInfo curr = sortedMethods[i3];
            int flags = curr.getAccessFlags();
            if (!Flags.isPrivate(flags) && !curr.isClinit()) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xD3F);
                doos.writeUTF(SerialVersionHashOperation.getClassName(curr.getDescriptor()));
            }
            ++i3;
        }
        doos.flush();
        return SerialVersionHashOperation.computeHash(os.toByteArray());
    }

    private static int getClassModifiers(IClassFileReader cfReader) {
        IInnerClassesAttribute innerClassesAttribute = cfReader.getInnerClassesAttribute();
        if (innerClassesAttribute != null) {
            IInnerClassesAttributeEntry[] entries = innerClassesAttribute.getInnerClassAttributesEntries();
            int i = 0;
            while (i < entries.length) {
                IInnerClassesAttributeEntry entry = entries[i];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && CharOperation.equals(cfReader.getClassName(), innerClassName)) {
                    return entry.getAccessFlags();
                }
                ++i;
            }
        }
        return cfReader.getAccessFlags();
    }

    private static Long computeHash(byte[] bytes) {
        try {
            byte[] sha = MessageDigest.getInstance("SHA-1").digest(bytes);
            if (sha.length >= 8) {
                long hash = 0L;
                int i = 7;
                while (i >= 0) {
                    hash = hash << 8 | (long)(sha[i] & 0xFF);
                    --i;
                }
                return new Long(hash);
            }
        }
        catch (NoSuchAlgorithmException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private static char[][] getSortedInterfacesNames(IClassFileReader cfReader) {
        char[][] interfaceNames = cfReader.getInterfaceNames();
        Arrays.sort(interfaceNames, new Comparator<char[]>(){

            @Override
            public int compare(char[] o1, char[] o2) {
                return CharOperation.compareTo(o1, o2);
            }
        });
        return interfaceNames;
    }

    private static IFieldInfo[] getSortedFields(IClassFileReader cfReader) {
        IFieldInfo[] allFields = cfReader.getFieldInfos();
        Arrays.sort(allFields, new Comparator<IFieldInfo>(){

            @Override
            public int compare(IFieldInfo o1, IFieldInfo o2) {
                return CharOperation.compareTo(o1.getName(), o2.getName());
            }
        });
        return allFields;
    }

    private static boolean hasStaticClassInitializer(IClassFileReader cfReader) {
        IMethodInfo[] methodInfos = cfReader.getMethodInfos();
        int i = 0;
        while (i < methodInfos.length) {
            if (methodInfos[i].isClinit()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IMethodInfo[] getSortedMethods(IClassFileReader cfReader) {
        IMethodInfo[] allMethods = cfReader.getMethodInfos();
        Arrays.sort(allMethods, new Comparator<IMethodInfo>(){

            @Override
            public int compare(IMethodInfo mi1, IMethodInfo mi2) {
                if (mi1.isConstructor() != mi2.isConstructor()) {
                    return mi1.isConstructor() ? -1 : 1;
                }
                if (mi1.isConstructor()) {
                    return 0;
                }
                int res = CharOperation.compareTo(mi1.getName(), mi2.getName());
                if (res != 0) {
                    return res;
                }
                return CharOperation.compareTo(mi1.getDescriptor(), mi2.getDescriptor());
            }
        });
        return allMethods;
    }

    private static IFile getClassfile(ITypeBinding typeBinding) throws CoreException {
        IType type = (IType)typeBinding.getJavaElement();
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        IRegion region = JavaCore.newRegion();
        region.add(type.getCompilationUnit());
        String name = typeBinding.getBinaryName();
        if (name != null) {
            int packStart = name.lastIndexOf(46);
            if (packStart != -1) {
                name = name.substring(packStart + 1);
            }
        } else {
            throw new CoreException(new Status(4, "org.eclipse.jdt.ui", CorrectionMessages.SerialVersionHashOperation_error_classnotfound));
        }
        name = String.valueOf(name) + ".class";
        IResource[] classFiles = JavaCore.getGeneratedResources(region, false);
        int i = 0;
        while (i < classFiles.length) {
            IResource resource = classFiles[i];
            if (resource.getType() == 1 && resource.getName().equals(name)) {
                return (IFile)resource;
            }
            ++i;
        }
        throw new CoreException(new Status(4, "org.eclipse.jdt.ui", CorrectionMessages.SerialVersionHashOperation_error_classnotfound));
    }

    private static void displayErrorMessage(final String message) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        MessageDialog.openError((Shell)shell, (String)CorrectionMessages.SerialVersionHashOperation_dialog_error_caption, (String)Messages.format(CorrectionMessages.SerialVersionHashOperation_dialog_error_message, message));
                    }
                }
            });
        }
    }

    private static void displayErrorMessage(Throwable throwable) {
        SerialVersionHashOperation.displayErrorMessage(throwable.getLocalizedMessage());
    }

    private static boolean displayYesNoMessage(final String title, final String message) {
        final boolean[] result = new boolean[]{true};
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                    }
                }
            });
        }
        return result[0];
    }

    public SerialVersionHashOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
        this.fCompilationUnit = unit;
    }

    protected boolean addInitializer(final VariableDeclarationFragment fragment, final ASTNode declarationNode) {
        Assert.isNotNull(fragment);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public final void run(IProgressMonitor monitor) throws InterruptedException {
                    Assert.isNotNull(monitor);
                    String id = SerialVersionHashOperation.this.computeId(declarationNode, monitor);
                    fragment.setInitializer(fragment.getAST().newNumberLiteral(id));
                }
            });
        }
        catch (InvocationTargetException exception) {
            JavaPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModel positionGroups) {
    }

    private String computeId(ASTNode declarationNode, IProgressMonitor monitor) throws InterruptedException {
        long serialVersionID;
        block17: {
            Assert.isNotNull(monitor);
            serialVersionID = 1L;
            try {
                Long id;
                monitor.beginTask(CorrectionMessages.SerialVersionHashOperation_computing_id, 200);
                IJavaProject project = this.fCompilationUnit.getJavaProject();
                IPath path = this.fCompilationUnit.getResource().getFullPath();
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                try {
                    bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ITextFileBuffer buffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                    if (buffer.isDirty() && buffer.isStateValidated() && buffer.isCommitable() && SerialVersionHashOperation.displayYesNoMessage(CorrectionMessages.SerialVersionHashOperation_save_caption, CorrectionMessages.SerialVersionHashOperation_save_message)) {
                        buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 20), true);
                    } else {
                        monitor.worked(20);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    bufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                project.getProject().build(10, new SubProgressMonitor(monitor, 60));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ITypeBinding typeBinding = SerialVersionHashOperation.getTypeBinding(declarationNode);
                if (typeBinding != null && (id = SerialVersionHashOperation.calculateSerialVersionId(typeBinding, new SubProgressMonitor(monitor, 100))) != null) {
                    serialVersionID = id;
                }
            }
            catch (CoreException exception) {
                SerialVersionHashOperation.displayErrorMessage(exception);
                monitor.done();
                break block17;
            }
            catch (IOException exception) {
                try {
                    SerialVersionHashOperation.displayErrorMessage(exception);
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        return String.valueOf(serialVersionID) + "L";
    }

    private static ITypeBinding getTypeBinding(ASTNode parent) {
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            return type.resolveBinding();
        }
        return null;
    }
}

