/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodCorrectionProposal
extends LinkedCorrectionProposal {
    private ASTNode fNode;
    private ITypeBinding fSenderBinding;

    public AbstractMethodCorrectionProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        Assert.isTrue(binding != null && Bindings.isDeclarationBinding(binding));
        this.fNode = invocationNode;
        this.fSenderBinding = binding;
    }

    protected ASTNode getInvocationNode() {
        return this.fNode;
    }

    protected ITypeBinding getSenderBinding() {
        return this.fSenderBinding;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode typeDecl = astRoot.findDeclaringNode(this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            isInDifferentCU = false;
            newTypeDecl = typeDecl;
        } else {
            isInDifferentCU = true;
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        if (newTypeDecl != null) {
            ASTRewrite rewrite = ASTRewrite.create(astRoot.getAST());
            MethodDeclaration newStub = this.getStub(rewrite, newTypeDecl);
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
            List members = (List)newTypeDecl.getStructuralProperty(property);
            int insertIndex = this.isConstructor() ? this.findConstructorInsertIndex(members) : (!isInDifferentCU ? this.findMethodInsertIndex(members, this.fNode.getStartPosition()) : members.size());
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt(newStub, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private MethodDeclaration getStub(ASTRewrite rewrite, ASTNode targetTypeDecl) throws CoreException {
        String string;
        AST ast = targetTypeDecl.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        SimpleName newNameNode = this.getNewName(rewrite);
        decl.setConstructor(this.isConstructor());
        this.addNewModifiers(rewrite, targetTypeDecl, decl.modifiers());
        ArrayList<String> takenNames = new ArrayList<String>();
        this.addNewTypeParameters(rewrite, takenNames, decl.typeParameters());
        decl.setName(newNameNode);
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            takenNames.add(declaredFields[i].getName());
            ++i;
        }
        String bodyStatement = "";
        if (!this.isConstructor()) {
            boolean isVoid;
            Type returnType = this.getNewMethodType(rewrite);
            decl.setReturnType2(returnType);
            boolean bl = isVoid = returnType instanceof PrimitiveType && PrimitiveType.VOID.equals(((PrimitiveType)returnType).getPrimitiveTypeCode());
            if (!this.fSenderBinding.isInterface() && !isVoid) {
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(ASTNodeFactory.newDefaultExpression(ast, returnType, 0));
                bodyStatement = ASTNodes.asFormattedString(returnStatement, 0, String.valueOf('\n'), this.getCompilationUnit().getJavaProject().getOptions(true));
            }
        }
        this.addNewParameters(rewrite, takenNames, decl.parameters());
        this.addNewExceptions(rewrite, decl.thrownExceptions());
        Block body = null;
        if (!this.fSenderBinding.isInterface()) {
            body = ast.newBlock();
            String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), this.fSenderBinding.getName(), newNameNode.getIdentifier(), this.isConstructor(), bodyStatement, String.valueOf('\n'));
            if (placeHolder != null) {
                ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        decl.setBody(body);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaProject());
        if (settings.createComments && !this.fSenderBinding.isAnonymous() && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), this.fSenderBinding.getName(), decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private int findMethodInsertIndex(List<BodyDeclaration> decls, int currPos) {
        int nDecls = decls.size();
        int i = 0;
        while (i < nDecls) {
            BodyDeclaration curr = decls.get(i);
            if (curr instanceof MethodDeclaration && currPos < curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            ++i;
        }
        return nDecls;
    }

    private int findConstructorInsertIndex(List<BodyDeclaration> decls) {
        int nDecls = decls.size();
        int lastMethod = 0;
        int i = nDecls - 1;
        while (i >= 0) {
            BodyDeclaration curr = decls.get(i);
            if (curr instanceof MethodDeclaration) {
                if (((MethodDeclaration)curr).isConstructor()) {
                    return i + 1;
                }
                lastMethod = i;
            }
            --i;
        }
        return lastMethod;
    }

    protected abstract boolean isConstructor();

    protected abstract void addNewModifiers(ASTRewrite var1, ASTNode var2, List<IExtendedModifier> var3);

    protected abstract void addNewTypeParameters(ASTRewrite var1, List<String> var2, List<TypeParameter> var3) throws CoreException;

    protected abstract void addNewParameters(ASTRewrite var1, List<String> var2, List<SingleVariableDeclaration> var3) throws CoreException;

    protected abstract void addNewExceptions(ASTRewrite var1, List<Name> var2) throws CoreException;

    protected abstract SimpleName getNewName(ASTRewrite var1);

    protected abstract Type getNewMethodType(ASTRewrite var1) throws CoreException;
}

