/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionCommandHandler;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class ChangeCorrectionProposal
implements IJavaCompletionProposal,
ICommandAccess,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private static final NullChange COMPUTING_CHANGE = new NullChange("ChangeCorrectionProposal computing...");
    private Change fChange;
    private String fName;
    private int fRelevance;
    private Image fImage;
    private String fCommandId;

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
        this.fImage = image;
        this.fCommandId = null;
    }

    public void apply(IDocument document) {
        try {
            this.performChange(JavaPlugin.getActivePage().getActiveEditor(), document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.ChangeCorrectionProposal_error_title, CorrectionMessages.ChangeCorrectionProposal_error_message);
        }
    }

    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        block17: {
            StyledText disabledStyledText = null;
            TraverseListener traverseBlocker = null;
            Change change = null;
            IRewriteTarget rewriteTarget = null;
            try {
                Change undoChange;
                change = this.getChange();
                if (change == null) break block17;
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null) {
                    Object control;
                    rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class);
                    if (rewriteTarget != null) {
                        rewriteTarget.beginCompoundChange();
                    }
                    if ((control = activeEditor.getAdapter(Control.class)) instanceof StyledText) {
                        disabledStyledText = (StyledText)control;
                        if (disabledStyledText.getEditable()) {
                            disabledStyledText.setEditable(false);
                            traverseBlocker = new TraverseListener(){

                                public void keyTraversed(TraverseEvent e) {
                                    e.doit = true;
                                    e.detail = 0;
                                }
                            };
                            disabledStyledText.addTraverseListener(traverseBlocker);
                        } else {
                            disabledStyledText = null;
                        }
                    }
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, JavaPlugin.getPluginId(), 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException(status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange(change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed(change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getName(), undoChange);
                }
            }
            finally {
                if (disabledStyledText != null) {
                    disabledStyledText.setEditable(true);
                    disabledStyledText.removeTraverseListener(traverseBlocker);
                }
                if (rewriteTarget != null) {
                    rewriteTarget.endCompoundChange();
                }
                if (change != null) {
                    change.dispose();
                }
            }
        }
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo(new NullProgressMonitor());
        return info == null ? null : info.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuffer buf;
        block3: {
            String name;
            block4: {
                buf = new StringBuffer();
                buf.append("<p>");
                Change change = this.getChange();
                if (change == null) break block3;
                name = change.getName();
                if (name.length() != 0) break block4;
                return null;
            }
            try {
                buf.append(name);
            }
            catch (CoreException e) {
                buf.append("Unexpected error when accessing this proposal:<p><pre>");
                buf.append(e.getLocalizedMessage());
                buf.append("</pre>");
            }
        }
        return null;
        buf.append("</p>");
        return buf.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            return Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.getName(), shortCutString});
        }
        return this.getName();
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.getName());
        String shortCutString = CorrectionCommandHandler.getShortCutString(this.getCommandId());
        if (shortCutString != null) {
            String decorated = Messages.format(CorrectionMessages.ChangeCorrectionProposal_name_with_shortcut, new String[]{this.getName(), shortCutString});
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)str);
        }
        return str;
    }

    public String getName() {
        return this.fName;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Change getChange() throws CoreException {
        if (Util.isGtk()) {
            long end = System.currentTimeMillis() + 10000L;
            do {
                Object display;
                boolean computing;
                ChangeCorrectionProposal changeCorrectionProposal = this;
                synchronized (changeCorrectionProposal) {
                    computing = this.fChange == COMPUTING_CHANGE;
                }
                if (computing) {
                    try {
                        display = Display.getCurrent();
                        if (display != null) {
                            while (!display.isDisposed() && display.readAndDispatch()) {
                            }
                            display.sleep();
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                display = this;
                synchronized (display) {
                    if (this.fChange == COMPUTING_CHANGE) {
                        continue;
                    }
                    if (this.fChange != null) {
                        return this.fChange;
                    }
                    this.fChange = COMPUTING_CHANGE;
                }
                Change change = this.createChange();
                ChangeCorrectionProposal changeCorrectionProposal2 = this;
                synchronized (changeCorrectionProposal2) {
                    this.fChange = change;
                }
                return change;
            } while (System.currentTimeMillis() < end);
            ChangeCorrectionProposal changeCorrectionProposal = this;
            synchronized (changeCorrectionProposal) {
                block26: {
                    if (this.fChange != COMPUTING_CHANGE) break block26;
                    return null;
                }
            }
        }
        ChangeCorrectionProposal changeCorrectionProposal = this;
        synchronized (changeCorrectionProposal) {
            if (this.fChange == null) {
                this.fChange = this.createChange();
            }
        }
        return this.fChange;
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public String getCommandId() {
        return this.fCommandId;
    }

    public void setCommandId(String commandId) {
        this.fCommandId = commandId;
    }
}

