/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.fix.ILinkedFix;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.IMultiFix;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FixCorrectionProposal
extends CUCorrectionProposal
implements ICompletionProposalExtension2,
IStatusLineProposal {
    private final IProposableFix fFix;
    private final ICleanUp fCleanUp;
    private CompilationUnit fCompilationUnit;

    public FixCorrectionProposal(IProposableFix fix, ICleanUp cleanUp, int relevance, Image image, IInvocationContext context) {
        super(fix.getDisplayString(), context.getCompilationUnit(), null, relevance, image);
        this.fFix = fix;
        this.fCleanUp = cleanUp;
        this.fCompilationUnit = context.getASTRoot();
    }

    public ICleanUp getCleanUp() {
        return this.fCleanUp;
    }

    public Image getImage() {
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            ImageImageDescriptor image = new ImageImageDescriptor(super.getImage());
            int flag = 32;
            if (status.getSeverity() == 4) {
                flag = 64;
            }
            JavaElementImageDescriptor composite = new JavaElementImageDescriptor(image, flag, new Point(image.getImageData().width, image.getImageData().height));
            return composite.createImage();
        }
        return super.getImage();
    }

    public IStatus getFixStatus() {
        return this.fFix.getStatus();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        String info;
        StringBuffer result = new StringBuffer();
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            result.append("<b>");
            if (status.getSeverity() == 2) {
                result.append(CorrectionMessages.FixCorrectionProposal_WarningAdditionalProposalInfo);
            } else if (status.getSeverity() == 4) {
                result.append(CorrectionMessages.FixCorrectionProposal_ErrorAdditionalProposalInfo);
            }
            result.append("</b>");
            result.append(status.getMessage());
            result.append("<br><br>");
        }
        if ((info = this.fFix.getAdditionalProposalInfo()) != null) {
            result.append(info);
        } else {
            result.append(super.getAdditionalProposalInfo(monitor));
        }
        return result.toString();
    }

    public int getRelevance() {
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            return super.getRelevance() - 100;
        }
        return super.getRelevance();
    }

    protected TextChange createTextChange() throws CoreException {
        CompilationUnitChange createChange = this.fFix.createChange(null);
        createChange.setSaveMode(4);
        if (this.fFix instanceof ILinkedFix) {
            this.setLinkedProposalModel(((ILinkedFix)((Object)this.fFix)).getLinkedPositions());
        }
        return createChange;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        if (stateMask == 262144 && this.fCleanUp != null) {
            CleanUpRefactoring refactoring = new CleanUpRefactoring();
            refactoring.addCompilationUnit(this.getCompilationUnit());
            refactoring.addCleanUp(this.fCleanUp);
            refactoring.setLeaveFilesDirty(true);
            int stopSeverity = RefactoringCore.getConditionCheckingFailedSeverity();
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            RefactoringExecutionHelper executer = new RefactoringExecutionHelper(refactoring, stopSeverity, 3, shell, (IRunnableContext)context);
            try {
                executer.perform(true, true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                JavaPlugin.log(e);
            }
            return;
        }
        this.apply(viewer.getDocument());
    }

    public void resolve(CleanUpRefactoring.MultiFixTarget[] targets, final IProgressMonitor monitor) throws CoreException {
        if (targets.length == 0) {
            return;
        }
        if (this.fCleanUp == null) {
            return;
        }
        String[] descriptions = this.fCleanUp.getStepDescriptions();
        String changeName = descriptions.length == 1 ? descriptions[0] : CorrectionMessages.FixCorrectionProposal_MultiFixChange_label;
        CleanUpRefactoring refactoring = new CleanUpRefactoring(changeName);
        int i = 0;
        while (i < targets.length) {
            refactoring.addCleanUpTarget(targets[i]);
            ++i;
        }
        refactoring.addCleanUp(this.fCleanUp);
        IRunnableContext context = new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run(monitor == null ? new NullProgressMonitor() : monitor);
            }
        };
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper(refactoring, 1, 4, shell, context);
        try {
            helper.perform(true, true);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CoreException) {
                throw (CoreException)cause;
            }
            throw new CoreException(new Status(4, "org.eclipse.jdt.ui", cause.getLocalizedMessage(), cause));
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    public String getStatusMessage() {
        if (this.fCleanUp == null) {
            return null;
        }
        int count = this.computeNumberOfFixesForCleanUp(this.fCleanUp);
        if (count == -1) {
            return CorrectionMessages.FixCorrectionProposal_HitCtrlEnter_description;
        }
        if (count < 2) {
            return null;
        }
        return Messages.format(CorrectionMessages.FixCorrectionProposal_hitCtrlEnter_variable_description, new Integer(count));
    }

    public int computeNumberOfFixesForCleanUp(ICleanUp cleanUp) {
        return cleanUp instanceof IMultiFix ? ((IMultiFix)cleanUp).computeNumberOfFixes(this.fCompilationUnit) : -1;
    }
}

