/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class NewAnnotationMemberProposal
extends LinkedCorrectionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private final ASTNode fInvocationNode;
    private final ITypeBinding fSenderBinding;

    public NewAnnotationMemberProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fInvocationNode);
        ASTNode typeDecl = astRoot.findDeclaringNode(this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            newTypeDecl = typeDecl;
        } else {
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        if (newTypeDecl instanceof AnnotationTypeDeclaration) {
            ASTRewrite rewrite = ASTRewrite.create(astRoot.getAST());
            AnnotationTypeMemberDeclaration newStub = this.getStub(rewrite, (AnnotationTypeDeclaration)newTypeDecl);
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
            List members = (List)newTypeDecl.getStructuralProperty(property);
            int insertIndex = members.size();
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt(newStub, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private AnnotationTypeMemberDeclaration getStub(ASTRewrite rewrite, AnnotationTypeDeclaration targetTypeDecl) {
        AST ast = targetTypeDecl.getAST();
        AnnotationTypeMemberDeclaration decl = ast.newAnnotationTypeMemberDeclaration();
        SimpleName newNameNode = this.getNewName(rewrite);
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.evaluateModifiers(targetTypeDecl)));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, decl.modifiers(), true);
        decl.setName(newNameNode);
        Type returnType = this.getNewType(rewrite);
        decl.setType(returnType);
        return decl;
    }

    private Type getNewType(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        Type newTypeNode = null;
        ITypeBinding binding = null;
        if (this.fInvocationNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            Expression value = ((MemberValuePair)this.fInvocationNode.getParent()).getValue();
            binding = value.resolveTypeBinding();
        } else if (this.fInvocationNode instanceof Expression) {
            binding = ((Expression)this.fInvocationNode).resolveTypeBinding();
        }
        if (binding != null) {
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(this.fInvocationNode, this.getImportRewrite());
            newTypeNode = this.getImportRewrite().addImport(binding, ast, importRewriteContext);
        }
        if (newTypeNode == null) {
            newTypeNode = ast.newSimpleType(ast.newSimpleName("String"));
        }
        this.addLinkedPosition(rewrite.track(newTypeNode), false, KEY_TYPE);
        return newTypeNode;
    }

    private int evaluateModifiers(AnnotationTypeDeclaration targetTypeDecl) {
        List methodDecls = targetTypeDecl.bodyDeclarations();
        int i = 0;
        while (i < methodDecls.size()) {
            Object curr = methodDecls.get(i);
            if (curr instanceof AnnotationTypeMemberDeclaration) {
                return ((AnnotationTypeMemberDeclaration)curr).getModifiers();
            }
            ++i;
        }
        return 0;
    }

    private SimpleName getNewName(ASTRewrite rewrite) {
        String name;
        AST ast = rewrite.getAST();
        if (this.fInvocationNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            name = ((SimpleName)this.fInvocationNode).getIdentifier();
            if (ast == this.fInvocationNode.getAST()) {
                this.addLinkedPosition(rewrite.track(this.fInvocationNode), true, KEY_NAME);
            }
        } else {
            name = "value";
        }
        SimpleName newNameNode = ast.newSimpleName(name);
        this.addLinkedPosition(rewrite.track(newNameNode), false, KEY_NAME);
        return newNameNode;
    }
}

