/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.SharedASTProvider;

public class RemoveDeclarationCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private SimpleName fName;

    public RemoveDeclarationCorrectionProposal(ICompilationUnit cu, SimpleName name, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.fName = name;
    }

    public String getName() {
        IBinding binding = this.fName.resolveBinding();
        String name = BasicElementLabels.getJavaElementName(this.fName.getIdentifier());
        switch (binding.getKind()) {
            case 2: {
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedtype_description, name);
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedconstructor_description, name);
                }
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedmethod_description, name);
            }
            case 3: {
                if (((IVariableBinding)binding).isField()) {
                    return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedfield_description, name);
                }
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedvar_description, name);
            }
        }
        return super.getDisplayString();
    }

    protected ASTRewrite getRewrite() {
        ASTRewrite rewrite;
        IBinding binding = this.fName.resolveBinding();
        CompilationUnit root = (CompilationUnit)this.fName.getRoot();
        if (binding.getKind() == 4) {
            IMethodBinding decl = ((IMethodBinding)binding).getMethodDeclaration();
            ASTNode declaration = root.findDeclaringNode(decl);
            rewrite = ASTRewrite.create(root.getAST());
            rewrite.remove(declaration, null);
        } else if (binding.getKind() == 2) {
            ITypeBinding decl = ((ITypeBinding)binding).getTypeDeclaration();
            ASTNode declaration = root.findDeclaringNode(decl);
            rewrite = ASTRewrite.create(root.getAST());
            rewrite.remove(declaration, null);
        } else if (binding.getKind() == 3) {
            CompilationUnit completeRoot = SharedASTProvider.getAST(this.getCompilationUnit(), SharedASTProvider.WAIT_YES, null);
            SimpleName nameNode = (SimpleName)NodeFinder.perform(completeRoot, this.fName.getStartPosition(), this.fName.getLength());
            rewrite = ASTRewrite.create(completeRoot.getAST());
            SimpleName[] references = LinkedNodeFinder.findByBinding(completeRoot, nameNode.resolveBinding());
            int i = 0;
            while (i < references.length) {
                this.removeVariableReferences(rewrite, references[i]);
                ++i;
            }
            IVariableBinding bindingDecl = ((IVariableBinding)nameNode.resolveBinding()).getVariableDeclaration();
            ASTNode declaringNode = completeRoot.findDeclaringNode(bindingDecl);
            if (declaringNode instanceof SingleVariableDeclaration) {
                this.removeParamTag(rewrite, (SingleVariableDeclaration)declaringNode);
            }
        } else {
            throw new IllegalArgumentException("Unexpected binding");
        }
        return rewrite;
    }

    private void removeParamTag(ASTRewrite rewrite, SingleVariableDeclaration varDecl) {
        TagElement tagElement;
        Javadoc javadoc;
        if (varDecl.getParent() instanceof MethodDeclaration && (javadoc = ((MethodDeclaration)varDecl.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessor.findParamTag(javadoc, varDecl.getName().getIdentifier())) != null) {
            rewrite.remove(tagElement, null);
        }
    }

    private void removeVariableReferences(ASTRewrite rewrite, SimpleName reference) {
        int nameParentType;
        ASTNode parent = reference.getParent();
        while (parent instanceof QualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof FieldAccess) {
            parent = parent.getParent();
        }
        if ((nameParentType = parent.getNodeType()) == 7) {
            Assignment assignment = (Assignment)parent;
            Expression rightHand = assignment.getRightHandSide();
            ASTNode assignParent = assignment.getParent();
            if (assignParent.getNodeType() == 21 && rightHand.getNodeType() != 7) {
                this.removeVariableWithInitializer(rewrite, rightHand, assignParent);
            } else {
                rewrite.replace(assignment, rewrite.createCopyTarget(rightHand), null);
            }
        } else if (nameParentType == 44) {
            rewrite.remove(parent, null);
        } else if (nameParentType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
            ASTNode varDecl = frag.getParent();
            List fragments = varDecl instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)varDecl).fragments() : (varDecl instanceof FieldDeclaration ? ((FieldDeclaration)varDecl).fragments() : ((VariableDeclarationStatement)varDecl).fragments());
            if (fragments.size() == 1) {
                rewrite.remove(varDecl, null);
            } else {
                rewrite.remove(frag, null);
            }
        }
    }

    private void removeVariableWithInitializer(ASTRewrite rewrite, ASTNode initializerNode, ASTNode statementNode) {
        ArrayList<Expression> sideEffectNodes = new ArrayList<Expression>();
        initializerNode.accept(new SideEffectFinder(sideEffectNodes));
        int nSideEffects = sideEffectNodes.size();
        if (nSideEffects == 0) {
            if (ASTNodes.isControlStatementBody(statementNode.getLocationInParent())) {
                rewrite.replace(statementNode, rewrite.getAST().newBlock(), null);
            } else {
                rewrite.remove(statementNode, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SideEffectFinder
    extends ASTVisitor {
        private ArrayList<Expression> fSideEffectNodes;

        public SideEffectFinder(ArrayList<Expression> res) {
            this.fSideEffectNodes = res;
        }

        @Override
        public boolean visit(Assignment node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        @Override
        public boolean visit(PostfixExpression node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        @Override
        public boolean visit(PrefixExpression node) {
            PrefixExpression.Operator operator = node.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add(node);
            }
            return false;
        }

        @Override
        public boolean visit(MethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        @Override
        public boolean visit(ClassInstanceCreation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        @Override
        public boolean visit(SuperMethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }
    }
}

