/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompletionProposalComputerDescriptor {
    private static final String DEFAULT_CATEGORY_ID = "org.eclipse.jdt.ui.defaultProposalCategory";
    private static final String CATEGORY_ID = "categoryId";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String PARTITION = "partition";
    private static final Set<String> PARTITION_SET;
    private static final String PERFORMANCE_EVENT;
    private static final boolean MEASURE_PERFORMANCE;
    private static final long MAX_DELAY = 5000L;
    private static final String COMPUTE_COMPLETION_PROPOSALS = "computeCompletionProposals()";
    private static final String COMPUTE_CONTEXT_INFORMATION = "computeContextInformation()";
    private static final String SESSION_STARTED = "sessionStarted()";
    private static final String SESSION_ENDED = "sessionEnded()";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final Set<String> fPartitions;
    private final IConfigurationElement fElement;
    private final CompletionProposalComputerRegistry fRegistry;
    private IJavaCompletionProposalComputer fComputer;
    private final CompletionProposalCategory fCategory;
    private String fLastError;
    private boolean fIsReportingDelay = false;
    private long fStart;
    boolean fTriedLoadingComputer = false;

    static {
        PERFORMANCE_EVENT = String.valueOf(JavaPlugin.getPluginId()) + "/perf/content_assist/extensions";
        MEASURE_PERFORMANCE = PerformanceStats.isEnabled(PERFORMANCE_EVENT);
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("__dftl_partition_content_type");
        partitions.add("__java_javadoc");
        partitions.add("__java_multiline_comment");
        partitions.add("__java_singleline_comment");
        partitions.add("__java_string");
        partitions.add("__java_character");
        PARTITION_SET = Collections.unmodifiableSet(partitions);
    }

    CompletionProposalComputerDescriptor(IConfigurationElement element, CompletionProposalComputerRegistry registry, List<CompletionProposalCategory> categories) throws InvalidRegistryObjectException, CoreException {
        Assert.isLegal(registry != null);
        Assert.isLegal(element != null);
        this.fRegistry = registry;
        this.fElement = element;
        IExtension extension = element.getDeclaringExtension();
        this.fId = extension.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String name = extension.getLabel();
        this.fName = name.length() == 0 ? this.fId : name;
        HashSet<String> partitions = new HashSet<String>();
        IConfigurationElement[] children = element.getChildren(PARTITION);
        if (children.length == 0) {
            this.fPartitions = PARTITION_SET;
        } else {
            int i = 0;
            while (i < children.length) {
                String type = children[i].getAttribute(TYPE);
                this.checkNotNull(type, TYPE);
                partitions.add(type);
                ++i;
            }
            this.fPartitions = Collections.unmodifiableSet(partitions);
        }
        String activateAttribute = element.getAttribute(ACTIVATE);
        this.fActivate = Boolean.valueOf(activateAttribute);
        this.fClass = element.getAttribute(CLASS);
        this.checkNotNull(this.fClass, CLASS);
        String categoryId = element.getAttribute(CATEGORY_ID);
        if (categoryId == null) {
            categoryId = DEFAULT_CATEGORY_ID;
        }
        CompletionProposalCategory category = null;
        for (CompletionProposalCategory cat : categories) {
            if (!cat.getId().equals(categoryId)) continue;
            category = cat;
            break;
        }
        if (category == null) {
            this.fCategory = new CompletionProposalCategory(categoryId, this.fName, registry);
            categories.add(this.fCategory);
        } else {
            this.fCategory = category;
        }
    }

    private void checkNotNull(Object value, String attribute) throws InvalidRegistryObjectException, CoreException {
        if (value == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getContributor().getName(), attribute};
            String message = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, null);
            throw new CoreException(status);
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public Set<String> getPartitions() {
        return this.fPartitions;
    }

    private synchronized IJavaCompletionProposalComputer getComputer(boolean canCreate) throws CoreException, InvalidRegistryObjectException {
        if (this.fComputer == null && canCreate && !this.fTriedLoadingComputer && (this.fActivate || this.isPluginLoaded())) {
            this.fTriedLoadingComputer = true;
            this.fComputer = this.createComputer();
        }
        return this.fComputer;
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle(namespace);
        return bundle;
    }

    public IJavaCompletionProposalComputer createComputer() throws CoreException, InvalidRegistryObjectException {
        return (IJavaCompletionProposalComputer)this.fElement.createExecutableExtension(CLASS);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        block17: {
            if (!this.isEnabled()) {
                return Collections.emptyList();
            }
            computer = this.getComputer(true);
            if (computer == null) {
                var10_7 = Collections.emptyList();
            }
            ** GOTO lbl29
            {
                catch (InvalidRegistryObjectException x) {
                    status = this.createExceptionStatus(x);
                    monitor.done();
                    break block17;
                }
                catch (CoreException x) {
                    status = this.createExceptionStatus(x);
                    break block17;
                    catch (RuntimeException x) {
                        status = this.createExceptionStatus(x);
                        monitor.done();
                        break block17;
                    }
                    finally {
                        monitor.done();
                    }
                }
                monitor.done();
                return var10_7;
lbl29:
                // 1 sources

                try {
                    stats = this.startMeter(context, computer);
                    proposals = computer.computeCompletionProposals(context, monitor);
                    this.stopMeter(stats, "computeCompletionProposals()");
                    if (proposals != null) {
                        this.fLastError = computer.getErrorMessage();
                        var8_10 = proposals;
                        this.fIsReportingDelay = true;
                        monitor.done();
                        return var8_10;
                    }
                }
                finally {
                    this.fIsReportingDelay = true;
                }
            }
            {
                status = this.createAPIViolationStatus("computeCompletionProposals()");
            }
            monitor.done();
        }
        this.fRegistry.informUser(this, status);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        block13: {
            if (!this.isEnabled()) {
                return Collections.emptyList();
            }
            try {
                computer = this.getComputer(true);
                if (computer == null) {
                    var8_7 = Collections.emptyList();
                }
                ** GOTO lbl-1000
            }
            catch (InvalidRegistryObjectException x) {
                status = this.createExceptionStatus(x);
                monitor.done();
                break block13;
            }
            catch (CoreException x) {
                status = this.createExceptionStatus(x);
                break block13;
                catch (RuntimeException x) {
                    status = this.createExceptionStatus(x);
                    monitor.done();
                    break block13;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
            return var8_7;
lbl-1000:
            // 1 sources

            {
                stats = this.startMeter(context, computer);
                proposals = computer.computeContextInformation(context, monitor);
                this.stopMeter(stats, "computeContextInformation()");
                if (proposals == null) ** GOTO lbl-1000
                this.fLastError = computer.getErrorMessage();
                var8_8 = proposals;
            }
            monitor.done();
            return var8_8;
lbl-1000:
            // 1 sources

            {
                status = this.createAPIViolationStatus("computeContextInformation()");
            }
            monitor.done();
        }
        this.fRegistry.informUser(this, status);
        return Collections.emptyList();
    }

    public void sessionStarted() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer computer = this.getComputer(true);
            if (computer == null) {
                return;
            }
            PerformanceStats stats = this.startMeter(SESSION_STARTED, computer);
            computer.sessionStarted();
            this.stopMeter(stats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    public void sessionEnded() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer computer = this.getComputer(false);
            if (computer == null) {
                return;
            }
            PerformanceStats stats = this.startMeter(SESSION_ENDED, computer);
            computer.sessionEnded();
            this.stopMeter(stats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    private PerformanceStats startMeter(Object context, IJavaCompletionProposalComputer computer) {
        PerformanceStats stats;
        if (MEASURE_PERFORMANCE) {
            stats = PerformanceStats.getStats(PERFORMANCE_EVENT, computer);
            stats.startRun(context.toString());
        } else {
            stats = null;
        }
        if (this.fIsReportingDelay) {
            this.fStart = System.currentTimeMillis();
        }
        return stats;
    }

    private void stopMeter(PerformanceStats stats, String operation) {
        long current;
        if (MEASURE_PERFORMANCE) {
            stats.endRun();
            if (stats.isFailure()) {
                IStatus status = this.createPerformanceStatus(operation);
                this.fRegistry.informUser(this, status);
                return;
            }
        }
        if (this.fIsReportingDelay && (current = System.currentTimeMillis()) - this.fStart > 5000L) {
            IStatus status = this.createPerformanceStatus(operation);
            this.fRegistry.informUser(this, status);
        }
    }

    private IStatus createExceptionStatus(InvalidRegistryObjectException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, x);
    }

    private IStatus createExceptionStatus(CoreException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, x);
    }

    private IStatus createExceptionStatus(RuntimeException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_runtime_ex;
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, x);
    }

    private IStatus createAPIViolationStatus(String operation) {
        String blame = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_API, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, null);
    }

    private IStatus createPerformanceStatus(String operation) {
        String blame = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_performance, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, null);
    }

    private String createBlameMessage() {
        Object[] args = new Object[]{this.getName(), this.fElement.getDeclaringExtension().getContributor().getName()};
        String disable = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_blame_message, args);
        return disable;
    }

    private boolean isEnabled() {
        return this.fCategory.isEnabled();
    }

    CompletionProposalCategory getCategory() {
        return this.fCategory;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    IContributor getContributor() {
        try {
            return this.fElement.getContributor();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }
}

