/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public abstract class AbstractAnnotationHover
extends AbstractJavaEditorTextHover {
    private final IPreferenceStore fStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
    private final DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private final boolean fAllAnnotations;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model;
        IPath path;
        if (textViewer instanceof ISourceViewer) {
            path = null;
            model = ((ISourceViewer)textViewer).getAnnotationModel();
        } else {
            path = this.getEditorInputPath();
            model = this.getAnnotationModel(path);
        }
        if (model == null) {
            return null;
        }
        try {
            Iterator parent = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(hoverRegion.getOffset(), hoverRegion.getLength(), true, true) : model.getAnnotationIterator();
            JavaAnnotationIterator e = new JavaAnnotationIterator(parent, this.fAllAnnotations);
            int layer = -1;
            Annotation annotation = null;
            Position position = null;
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                AnnotationPreference preference = AbstractAnnotationHover.getAnnotationPreference(a);
                if (preference == null || (preference.getTextPreferenceKey() == null || !this.fStore.getBoolean(preference.getTextPreferenceKey())) && (preference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(preference.getHighlightPreferenceKey()))) continue;
                Position p = model.getPosition(a);
                int l = this.fAnnotationAccess.getLayer(a);
                if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                layer = l;
                annotation = a;
                position = p;
            }
            if (layer > -1) {
                AnnotationInfo annotationInfo = this.createAnnotationInfo(annotation, position, textViewer);
                return annotationInfo;
            }
        }
        finally {
            try {
                if (path != null) {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    protected AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new AnnotationInfo(annotation, position, textViewer);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    private IPath getEditorInputPath() {
        if (this.getEditor() == null) {
            return null;
        }
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel(IPath path) {
        if (path == null) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, LocationKind.NORMALIZE, null);
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex.getStatus());
            return null;
        }
        IAnnotationModel model = null;
        try {
            IAnnotationModel iAnnotationModel = model = manager.getTextFileBuffer(path, LocationKind.NORMALIZE).getAnnotationModel();
            return iAnnotationModel;
        }
        finally {
            if (model == null) {
                try {
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex.getStatus());
                }
            }
        }
    }

    private static AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    protected static class AnnotationInfo {
        public final Annotation annotation;
        public final Position position;
        public final ITextViewer viewer;

        public AnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            this.annotation = annotation;
            this.position = position;
            this.viewer = textViewer;
        }

        public ICompletionProposal[] getCompletionProposals() {
            return new ICompletionProposal[0];
        }

        public void fillToolBar(ToolBarManager manager, IInformationControl infoControl) {
            ConfigureAnnotationsAction configureAnnotationsAction = new ConfigureAnnotationsAction(this.annotation, infoControl);
            manager.add((IAction)configureAnnotationsAction);
        }
    }

    private static class AnnotationInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private final DefaultMarkerAnnotationAccess fMarkerAnnotationAccess = new DefaultMarkerAnnotationAccess();
        private Control fFocusControl;
        private AnnotationInfo fInput;
        private Composite fParent;

        public AnnotationInformationControl(Shell parentShell, String statusFieldText) {
            super(parentShell, statusFieldText);
            this.create();
        }

        public AnnotationInformationControl(Shell parentShell, ToolBarManager toolBarManager) {
            super(parentShell, toolBarManager);
            this.create();
        }

        public void setInformation(String information) {
        }

        public void setInput(Object input) {
            Assert.isLegal(input instanceof AnnotationInfo);
            this.fInput = (AnnotationInfo)input;
            this.disposeDeferredCreatedContent();
            this.deferredCreateContent();
        }

        public boolean hasContents() {
            return this.fInput != null;
        }

        private AnnotationInfo getAnnotationInfo() {
            return this.fInput;
        }

        public void setFocus() {
            super.setFocus();
            if (this.fFocusControl != null) {
                this.fFocusControl.setFocus();
            }
        }

        public final void setVisible(boolean visible) {
            if (!visible) {
                this.disposeDeferredCreatedContent();
            }
            super.setVisible(visible);
        }

        protected void disposeDeferredCreatedContent() {
            Control[] children = this.fParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            ToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager != null) {
                toolBarManager.removeAll();
            }
        }

        protected void createContent(Composite parent) {
            this.fParent = parent;
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.fParent.setLayout((Layout)layout);
        }

        public Point computeSizeHint() {
            Point preferedSize = this.getShell().computeSize(-1, -1, true);
            Point constrains = this.getSizeConstraints();
            if (constrains == null) {
                return preferedSize;
            }
            Point constrainedSize = this.getShell().computeSize(constrains.x, -1, true);
            int width = Math.min(preferedSize.x, constrainedSize.x);
            int height = Math.max(preferedSize.y, constrainedSize.y);
            return new Point(width, height);
        }

        protected void fillToolbar() {
            ToolBarManager toolBarManager = this.getToolBarManager();
            if (toolBarManager == null) {
                return;
            }
            this.fInput.fillToolBar(toolBarManager, (IInformationControl)this);
            toolBarManager.update(true);
        }

        protected void deferredCreateContent() {
            this.fillToolbar();
            this.createAnnotationInformation(this.fParent, this.getAnnotationInfo().annotation);
            this.setColorAndFont((Control)this.fParent, this.fParent.getForeground(), this.fParent.getBackground(), JFaceResources.getDialogFont());
            ICompletionProposal[] proposals = this.getAnnotationInfo().getCompletionProposals();
            if (proposals.length > 0) {
                this.createCompletionProposalsControl(this.fParent, proposals);
            }
            this.fParent.layout(true);
        }

        private void setColorAndFont(Control control, Color foreground, Color background, Font font) {
            control.setForeground(foreground);
            control.setBackground(background);
            control.setFont(font);
            if (control instanceof Composite) {
                Control[] children = ((Composite)control).getChildren();
                int i = 0;
                while (i < children.length) {
                    this.setColorAndFont(children[i], foreground, background, font);
                    ++i;
                }
            }
        }

        private void createAnnotationInformation(Composite parent, final Annotation annotation) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 2;
            layout.marginWidth = 2;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            final Canvas canvas = new Canvas(composite, 524288);
            GridData gridData = new GridData(1, 1, false, false);
            gridData.widthHint = 17;
            gridData.heightHint = 16;
            canvas.setLayoutData((Object)gridData);
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setFont(null);
                    AnnotationInformationControl.this.fMarkerAnnotationAccess.paint(annotation, e.gc, canvas, new Rectangle(0, 0, 16, 16));
                }
            });
            StyledText text = new StyledText(composite, 74);
            GridData data = new GridData(4, 4, true, true);
            text.setLayoutData((Object)data);
            String annotationText = annotation.getText();
            if (annotationText != null) {
                text.setText(annotationText);
            }
        }

        private void createCompletionProposalsControl(Composite parent, ICompletionProposal[] proposals) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout2 = new GridLayout(1, false);
            layout2.marginHeight = 0;
            layout2.marginWidth = 0;
            layout2.verticalSpacing = 2;
            composite.setLayout((Layout)layout2);
            Label separator = new Label(composite, 258);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            separator.setLayoutData((Object)gridData);
            Label quickFixLabel = new Label(composite, 0);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            layoutData.horizontalIndent = 4;
            quickFixLabel.setLayoutData((Object)layoutData);
            String text = proposals.length == 1 ? JavaHoverMessages.AbstractAnnotationHover_message_singleQuickFix : Messages.format(JavaHoverMessages.AbstractAnnotationHover_message_multipleQuickFix, new Object[]{String.valueOf(proposals.length)});
            quickFixLabel.setText(text);
            this.setColorAndFont((Control)composite, parent.getForeground(), parent.getBackground(), JFaceResources.getDialogFont());
            this.createCompletionProposalsList(composite, proposals);
        }

        private void createCompletionProposalsList(Composite parent, ICompletionProposal[] proposals) {
            final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
            GridData gridData = new GridData(4, 4, true, true);
            scrolledComposite.setLayoutData((Object)gridData);
            scrolledComposite.setExpandVertical(false);
            scrolledComposite.setExpandHorizontal(false);
            Composite composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(2, false);
            layout.marginLeft = 5;
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            ArrayList<Link> list = new ArrayList<Link>();
            int i = 0;
            while (i < proposals.length) {
                FixCorrectionProposal proposal;
                int count;
                list.add(this.createCompletionProposalLink(composite, proposals[i], 1));
                if (proposals[i] instanceof FixCorrectionProposal && (count = (proposal = (FixCorrectionProposal)proposals[i]).computeNumberOfFixesForCleanUp(proposal.getCleanUp())) > 1) {
                    list.add(this.createCompletionProposalLink(composite, proposals[i], count));
                }
                ++i;
            }
            final Link[] links = list.toArray(new Link[list.size()]);
            scrolledComposite.setContent((Control)composite);
            this.setColorAndFont((Control)scrolledComposite, parent.getForeground(), parent.getBackground(), JFaceResources.getDialogFont());
            Point contentSize = composite.computeSize(-1, -1);
            composite.setSize(contentSize);
            Point constraints = this.getSizeConstraints();
            if (constraints != null && contentSize.x < constraints.x) {
                int scrollBarHeight;
                ScrollBar horizontalBar = scrolledComposite.getHorizontalBar();
                if (horizontalBar == null) {
                    Point scrollSize = scrolledComposite.computeSize(-1, -1);
                    scrollBarHeight = scrollSize.y - contentSize.y;
                } else {
                    scrollBarHeight = horizontalBar.getSize().y;
                }
                gridData.heightHint = contentSize.y - scrollBarHeight;
            }
            this.fFocusControl = links[0];
            int i2 = 0;
            while (i2 < links.length) {
                final int index = i2++;
                final Link link = links[index];
                link.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        switch (e.keyCode) {
                            case 0x1000002: {
                                if (index + 1 >= links.length) break;
                                links[index + 1].setFocus();
                                break;
                            }
                            case 0x1000001: {
                                if (index <= 0) break;
                                links[index - 1].setFocus();
                                break;
                            }
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
                link.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        int currentPosition = scrolledComposite.getOrigin().y;
                        int hight = scrolledComposite.getSize().y;
                        int linkPosition = link.getLocation().y;
                        if (linkPosition < currentPosition) {
                            if (linkPosition < 10) {
                                linkPosition = 0;
                            }
                            scrolledComposite.setOrigin(0, linkPosition);
                        } else if (linkPosition + 20 > currentPosition + hight) {
                            scrolledComposite.setOrigin(0, linkPosition - hight + link.getSize().y);
                        }
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        }

        private Link createCompletionProposalLink(Composite parent, final ICompletionProposal proposal, int count) {
            Image image;
            boolean isMultiFix;
            boolean bl = isMultiFix = count > 1;
            if (isMultiFix) {
                new Label(parent, 0);
                parent = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                parent.setLayout((Layout)layout);
            }
            Label proposalImage = new Label(parent, 0);
            proposalImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Image image2 = image = isMultiFix ? JavaPluginImages.get("org.eclipse.jdt.ui.correction_multi_fix.gif") : proposal.getImage();
            if (image != null) {
                proposalImage.setImage(image);
                proposalImage.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseUp(MouseEvent e) {
                        if (e.button == 1) {
                            AnnotationInformationControl.this.apply(proposal, ((AnnotationInformationControl)AnnotationInformationControl.this).fInput.viewer, ((AnnotationInformationControl)AnnotationInformationControl.this).fInput.position.offset, isMultiFix);
                        }
                    }
                });
            }
            Link proposalLink = new Link(parent, 64);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            String linkText = isMultiFix ? Messages.format(JavaHoverMessages.AbstractAnnotationHover_multifix_variable_description, new Integer(count)) : proposal.getDisplayString();
            proposalLink.setText("<a>" + linkText + "</a>");
            proposalLink.setLayoutData((Object)layoutData);
            proposalLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AnnotationInformationControl.this.apply(proposal, ((AnnotationInformationControl)AnnotationInformationControl.this).fInput.viewer, ((AnnotationInformationControl)AnnotationInformationControl.this).fInput.position.offset, isMultiFix);
                }
            });
            return proposalLink;
        }

        private void apply(ICompletionProposal p, ITextViewer viewer, int offset, boolean isMultiFix) {
            this.dispose();
            IRewriteTarget target = null;
            try {
                ICompletionProposalExtension2 e;
                IDocument document = viewer.getDocument();
                if (viewer instanceof ITextViewerExtension) {
                    ITextViewerExtension extension = (ITextViewerExtension)viewer;
                    target = extension.getRewriteTarget();
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                if (p instanceof ICompletionProposalExtension2) {
                    e = (ICompletionProposalExtension2)p;
                    e.apply(viewer, '\u0000', isMultiFix ? 262144 : 0, offset);
                } else if (p instanceof ICompletionProposalExtension) {
                    e = (ICompletionProposalExtension)p;
                    e.apply(document, '\u0000', offset);
                } else {
                    p.apply(document);
                }
                Point selection = p.getSelection(document);
                if (selection != null) {
                    viewer.setSelectedRange(selection.x, selection.y);
                    viewer.revealRange(selection.x, selection.y);
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    private static final class ConfigureAnnotationsAction
    extends Action {
        private final Annotation fAnnotation;
        private final IInformationControl fInfoControl;

        public ConfigureAnnotationsAction(Annotation annotation, IInformationControl infoControl) {
            this.fAnnotation = annotation;
            this.fInfoControl = infoControl;
            this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_ANNOTATIONS);
            this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_ANNOTATIONS);
            this.setToolTipText(JavaHoverMessages.AbstractAnnotationHover_action_configureAnnotationPreferences);
        }

        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            String data = null;
            AnnotationPreference preference = AbstractAnnotationHover.getAnnotationPreference(this.fAnnotation);
            if (preference != null) {
                data = preference.getPreferenceLabel();
            }
            this.fInfoControl.dispose();
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.editors.preferencePages.Annotations", null, (Object)data).open();
        }
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator presenterControlCreator) {
            this.fPresenterControlCreator = presenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new AnnotationInformationControl(parent, EditorsUI.getTooltipAffordanceString()){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return HoverControlCreator.this.fPresenterControlCreator;
                }
            };
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new AnnotationInformationControl(parent, new ToolBarManager(0x800000));
        }
    }
}

