/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.ui.ITypeHierarchyViewPart;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PlatformUI;

public class FocusOnSelectionAction
extends Action {
    private ITypeHierarchyViewPart fViewPart;

    public FocusOnSelectionAction(ITypeHierarchyViewPart part) {
        super(TypeHierarchyMessages.FocusOnSelectionAction_label);
        this.setDescription(TypeHierarchyMessages.FocusOnSelectionAction_description);
        this.setToolTipText(TypeHierarchyMessages.FocusOnSelectionAction_tooltip);
        this.fViewPart = part;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.focus_on_selection_action");
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fViewPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof IType) {
            this.fViewPart.setInputElement((IType)element);
        }
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof IType) {
            IType type = (IType)element;
            this.setText(Messages.format(TypeHierarchyMessages.FocusOnSelectionAction_label, JavaElementLabels.getTextLabel(type, 0L)));
            return true;
        }
        return false;
    }
}

