/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.PlatformUI;

public class HistoryAction
extends Action {
    private TypeHierarchyViewPart fViewPart;
    private IJavaElement[] fElements;

    public HistoryAction(TypeHierarchyViewPart viewPart, IJavaElement[] elements) {
        super("", 8);
        this.fViewPart = viewPart;
        this.fElements = elements;
        String elementName = HistoryAction.getElementLabel(elements);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor(elements[0]));
        this.setDescription(Messages.format(TypeHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(Messages.format(TypeHierarchyMessages.HistoryAction_tooltip, elementName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.history_action");
    }

    private ImageDescriptor getImageDescriptor(IJavaElement elem) {
        JavaElementImageProvider imageProvider = new JavaElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fViewPart.gotoHistoryEntry(this.fElements);
    }

    static StyledString getSingleElementLabel(IJavaElement element) {
        return JavaElementLabels.getStyledElementLabel(element, JavaElementLabels.ALL_POST_QUALIFIED | 0x80000000000000L | 0x2000000000L);
    }

    static String getElementLabel(IJavaElement[] elements) {
        switch (elements.length) {
            case 0: {
                Assert.isTrue(false);
                return null;
            }
            case 1: {
                return Messages.format(TypeHierarchyMessages.HistoryAction_inputElements_1, new String[]{HistoryAction.getShortLabel(elements[0])});
            }
            case 2: {
                return Messages.format(TypeHierarchyMessages.HistoryAction_inputElements_2, new String[]{HistoryAction.getShortLabel(elements[0]), HistoryAction.getShortLabel(elements[1])});
            }
        }
        return Messages.format(TypeHierarchyMessages.HistoryAction_inputElements_more, new String[]{HistoryAction.getShortLabel(elements[0]), HistoryAction.getShortLabel(elements[1]), HistoryAction.getShortLabel(elements[2])});
    }

    static String getShortLabel(IJavaElement element) {
        return JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_POST_QUALIFIED | 0x2000000000L);
    }
}

