/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class RowLayouter {
    public int spanHorizontalAlignment = -1;
    public int spanGrabExcessHorizontalSpace = -1;
    public int spanHorizontalSpan = -1;
    public int spanHorizontalIndent = -1;
    public int spanWidthHint = -1;
    public int spanVerticalAlignment = -1;
    public int spanGrabExcessVerticalSpace = -1;
    public int spanVerticalSpan = -1;
    public int spanHeightHint = -1;
    private int fNumColumns;
    private boolean fOrder;
    private Control fLastControl;
    private GridData[] fDefaultGridDatas = new GridData[4];

    public RowLayouter(int numColumns) {
        this(numColumns, false);
    }

    public RowLayouter(int numColumns, boolean order) {
        this.fNumColumns = numColumns;
        this.fOrder = order;
    }

    public void setDefaultSpan() {
        this.spanHorizontalAlignment = 4;
        this.spanGrabExcessHorizontalSpace = 1;
    }

    public void perform(Control c1) {
        this.perform(new Control[]{c1}, 0);
    }

    public void perform(Control c1, Control c2, int span) {
        this.perform(new Control[]{c1, c2}, span);
    }

    public void perform(Control c1, Control c2, Control c3, int span) {
        this.perform(new Control[]{c1, c2, c3}, span);
    }

    public void perform(Control[] controls, int spanColumn) {
        int numColumns = this.numColumns();
        Assert.isTrue(controls.length <= numColumns);
        this.order(controls);
        int gridIndex = 0;
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            GridData gd = (GridData)control.getLayoutData();
            if (gd == null) {
                gd = this.getGridData(gridIndex);
            }
            if (i == spanColumn) {
                int span = numColumns - (controls.length - 1);
                gridIndex += span;
                if (gd == null) {
                    gd = new GridData();
                }
                this.applyDelta(gd);
                gd.horizontalSpan = span;
            } else {
                ++gridIndex;
            }
            control.setLayoutData((Object)gd);
            ++i;
        }
    }

    private void applyDelta(GridData gd) {
        if (this.spanHorizontalAlignment != -1) {
            gd.horizontalAlignment = this.spanHorizontalAlignment;
        }
        if (this.spanGrabExcessHorizontalSpace != -1) {
            gd.grabExcessHorizontalSpace = this.spanGrabExcessHorizontalSpace != 0;
        }
        if (this.spanHorizontalSpan != -1) {
            gd.horizontalSpan = this.spanHorizontalSpan;
        }
        if (this.spanHorizontalIndent != -1) {
            gd.horizontalIndent = this.spanHorizontalIndent;
        }
        if (this.spanWidthHint != -1) {
            gd.widthHint = this.spanWidthHint;
        }
        if (this.spanVerticalAlignment != -1) {
            gd.verticalAlignment = this.spanVerticalAlignment;
        }
        if (this.spanGrabExcessVerticalSpace != -1) {
            gd.grabExcessVerticalSpace = this.spanGrabExcessVerticalSpace != 0;
        }
        if (this.spanVerticalSpan != -1) {
            gd.verticalSpan = this.spanVerticalSpan;
        }
        if (this.spanHeightHint != -1) {
            gd.heightHint = this.spanHeightHint;
        }
    }

    public void setDefaultGridData(GridData gd, int index) {
        if (index >= this.fDefaultGridDatas.length) {
            GridData[] newDatas = new GridData[index + 4];
            System.arraycopy(this.fDefaultGridDatas, 0, newDatas, 0, this.fDefaultGridDatas.length);
            this.fDefaultGridDatas = newDatas;
        }
        this.fDefaultGridDatas[index] = gd;
    }

    public GridData getGridData(int index) {
        if (index > this.fDefaultGridDatas.length) {
            return null;
        }
        return this.cloneGridData(this.fDefaultGridDatas[index]);
    }

    public int numColumns() {
        return this.fNumColumns;
    }

    protected void order(Control[] controls) {
        if (!this.fOrder) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.moveBelow(this.fLastControl);
            this.fLastControl = control;
            ++i;
        }
    }

    protected GridData cloneGridData(GridData gd) {
        if (gd == null) {
            return null;
        }
        GridData result = new GridData();
        result.horizontalAlignment = gd.horizontalAlignment;
        result.grabExcessHorizontalSpace = gd.grabExcessHorizontalSpace;
        result.horizontalSpan = gd.horizontalSpan;
        result.horizontalIndent = gd.horizontalIndent;
        result.widthHint = gd.widthHint;
        result.verticalAlignment = gd.verticalAlignment;
        result.grabExcessVerticalSpace = gd.grabExcessVerticalSpace;
        result.verticalSpan = gd.verticalSpan;
        result.heightHint = gd.heightHint;
        return result;
    }
}

