/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.jdt.ui.wizards.ClasspathAttributeConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildPathBasePage {
    private final ClasspathAttributeConfigurationDescriptors fAttributeDescriptors = JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();

    protected boolean editCustomAttribute(Shell shell, CPListElementAttribute elem) {
        IClasspathAttribute result;
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null && (result = config.performEdit(shell, elem.getClasspathAttributeAccess())) != null) {
            elem.setValue(result.getValue());
            return true;
        }
        return false;
    }

    protected boolean removeCustomAttribute(CPListElementAttribute elem) {
        IClasspathAttribute result;
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null && (result = config.performRemove(elem.getClasspathAttributeAccess())) != null) {
            elem.setValue(result.getValue());
            return true;
        }
        return false;
    }

    protected boolean canEditCustomAttribute(CPListElementAttribute elem) {
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null) {
            return config.canEdit(elem.getClasspathAttributeAccess());
        }
        return false;
    }

    protected boolean canRemoveCustomAttribute(CPListElementAttribute elem) {
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null) {
            return config.canRemove(elem.getClasspathAttributeAccess());
        }
        return false;
    }

    public abstract List<?> getSelection();

    public abstract void setSelection(List<?> var1, boolean var2);

    public void addElement(CPListElement element) {
    }

    public abstract boolean isEntryKind(int var1);

    protected void filterAndSetSelection(List<?> list) {
        ArrayList res = new ArrayList(list.size());
        int i = list.size() - 1;
        while (i >= 0) {
            CPListElement elem;
            Object curr = list.get(i);
            if (curr instanceof CPListElement && (elem = (CPListElement)curr).getParentContainer() == null && this.isEntryKind(elem.getEntryKind())) {
                res.add(curr);
            }
            --i;
        }
        this.setSelection(res, false);
    }

    public static void fixNestingConflicts(CPListElement[] newEntries, CPListElement[] existing, Set<CPListElement> modifiedSourceEntries) {
        int i = 0;
        while (i < newEntries.length) {
            BuildPathBasePage.addExclusionPatterns(newEntries[i], existing, modifiedSourceEntries);
            ++i;
        }
    }

    private static void addExclusionPatterns(CPListElement newEntry, CPListElement[] existing, Set<CPListElement> modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.length) {
            IPath currPath;
            CPListElement curr = existing[i];
            if (curr.getEntryKind() == 3 && !(currPath = curr.getPath()).equals(entryPath)) {
                if (currPath.isPrefixOf(entryPath)) {
                    if (BuildPathBasePage.addToExclusions(entryPath, curr)) {
                        modifiedEntries.add(curr);
                    }
                } else if (entryPath.isPrefixOf(currPath) && newEntry.getEntryKind() == 3 && BuildPathBasePage.addToExclusions(currPath, newEntry)) {
                    modifiedEntries.add(curr);
                }
            }
            ++i;
        }
    }

    private static boolean addToExclusions(IPath entryPath, CPListElement curr) {
        IPath[] exclusionFilters = (IPath[])curr.getAttribute("exclusion");
        if (!JavaModelUtil.isExcludedPath(entryPath, exclusionFilters)) {
            IPath pathToExclude = entryPath.removeFirstSegments(curr.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
            System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
            newExclusionFilters[exclusionFilters.length] = pathToExclude;
            curr.setAttribute("exclusion", newExclusionFilters);
            return true;
        }
        return false;
    }

    protected boolean containsOnlyTopLevelEntries(List<?> selElements) {
        if (selElements.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElement) {
                if (((CPListElement)elem).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract void init(IJavaProject var1);

    public abstract Control getControl(Composite var1);

    public abstract void setFocus();
}

