/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPathSupport {
    public static final String JRE_PREF_PAGE_ID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
    public static final String EE_PREF_PAGE_ID = "org.eclipse.jdt.debug.ui.jreProfiles";
    private static final String[] PREFS_COMPLIANCE = new String[]{"org.eclipse.jdt.core.compiler.problem.assertIdentifier", "org.eclipse.jdt.core.compiler.problem.enumIdentifier", "org.eclipse.jdt.core.compiler.source", "org.eclipse.jdt.core.compiler.codegen.targetPlatform", "org.eclipse.jdt.core.compiler.compliance"};

    private BuildPathSupport() {
    }

    public static String getDeprecationMessage(String variableName) {
        String deprecationMessage = JavaCore.getClasspathVariableDeprecationMessage(variableName);
        if (deprecationMessage == null) {
            return null;
        }
        return Messages.format(NewWizardMessages.BuildPathSupport_deprecated, new Object[]{variableName, deprecationMessage});
    }

    public static IPath guessSourceAttachment(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaProject currProject = elem.getJavaProject();
        try {
            IJavaModel jmodel = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaProject curr = jprojects[i];
                if (!curr.equals(currProject)) {
                    IClasspathEntry[] entries = curr.getRawClasspath();
                    int k = 0;
                    while (k < entries.length) {
                        IPath attachPath;
                        IClasspathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals(elem.getPath()) && (attachPath = entry.getSourceAttachmentPath()) != null && !attachPath.isEmpty()) {
                            return attachPath;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        return null;
    }

    public static String guessJavadocLocation(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaProject currProject = elem.getJavaProject();
        try {
            IJavaModel jmodel = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            int i = 0;
            while (i < jprojects.length) {
                IJavaProject curr = jprojects[i];
                if (!curr.equals(currProject)) {
                    IClasspathEntry[] entries = curr.getRawClasspath();
                    int k = 0;
                    while (k < entries.length) {
                        IClasspathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals(elem.getPath())) {
                            IClasspathAttribute[] attributes = entry.getExtraAttributes();
                            int n = 0;
                            while (n < attributes.length) {
                                IClasspathAttribute attrib = attributes[n];
                                if ("javadoc_location".equals(attrib.getName())) {
                                    return attrib.getValue();
                                }
                                ++n;
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        return null;
    }

    public static void modifyClasspathEntry(Shell shell, IClasspathEntry newEntry, String[] changedAttributes, IJavaProject jproject, IPath containerPath, boolean isReferencedEntry, IProgressMonitor monitor) throws CoreException {
        if (containerPath != null) {
            BuildPathSupport.updateContainerClasspath(jproject, containerPath, newEntry, changedAttributes, monitor);
        } else if (isReferencedEntry) {
            BuildPathSupport.updateReferencedClasspathEntry(jproject, newEntry, changedAttributes, monitor);
        } else {
            BuildPathSupport.updateProjectClasspath(shell, jproject, newEntry, changedAttributes, monitor);
        }
    }

    private static void updateContainerClasspath(IJavaProject jproject, IPath containerPath, IClasspathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer(containerPath, jproject);
        if (container == null) {
            throw new CoreException(new Status(4, "org.eclipse.jdt.ui", 4, "Container " + containerPath + " cannot be resolved", null));
        }
        IClasspathEntry[] entries = container.getClasspathEntries();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            newEntries[i] = curr.getEntryKind() == newEntry.getEntryKind() && curr.getPath().equals(newEntry.getPath()) ? BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject) : curr;
            ++i;
        }
        BuildPathSupport.requestContainerUpdate(jproject, container, newEntries);
        monitor.worked(1);
    }

    private static IClasspathEntry getUpdatedEntry(IClasspathEntry currEntry, IClasspathEntry updatedEntry, String[] updatedAttributes, IJavaProject jproject) {
        if (updatedAttributes == null) {
            return updatedEntry;
        }
        CPListElement currElem = CPListElement.createFromExisting(currEntry, jproject);
        CPListElement newElem = CPListElement.createFromExisting(updatedEntry, jproject);
        int i = 0;
        while (i < updatedAttributes.length) {
            String attrib = updatedAttributes[i];
            currElem.setAttribute(attrib, newElem.getAttribute(attrib));
            ++i;
        }
        return currElem.getClasspathEntry();
    }

    public static void requestContainerUpdate(IJavaProject jproject, IClasspathContainer container, IClasspathEntry[] newEntries) throws CoreException {
        IPath containerPath = container.getPath();
        UpdatedClasspathContainer updatedContainer = new UpdatedClasspathContainer(container, newEntries);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer(containerPath.segment(0));
        if (initializer != null) {
            initializer.requestClasspathContainerUpdate(containerPath, jproject, updatedContainer);
        }
    }

    private static void updateProjectClasspath(Shell shell, IJavaProject jproject, IClasspathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldClasspath = jproject.getRawClasspath();
        int nEntries = oldClasspath.length;
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IClasspathEntry curr = oldClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals(jarPath)) {
                newEntries.add(BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject));
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (!BuildPathSupport.putJarOnClasspathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        IClasspathEntry[] newClasspath = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        jproject.setRawClasspath(newClasspath, monitor);
    }

    private static boolean putJarOnClasspathDialog(final Shell shell) {
        if (shell == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = NewWizardMessages.BuildPathSupport_putoncpdialog_title;
                String message = NewWizardMessages.BuildPathSupport_putoncpdialog_message;
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static void updateReferencedClasspathEntry(IJavaProject jproject, IClasspathEntry newReferencedEntry, String[] changedAttributes, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] oldReferencedClasspath = jproject.getReferencedClasspathEntries();
        int nEntries = oldReferencedClasspath.length;
        ArrayList<IClasspathEntry> newReferencedEntries = new ArrayList<IClasspathEntry>(nEntries + 1);
        int entryKind = newReferencedEntry.getEntryKind();
        IPath jarPath = newReferencedEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IClasspathEntry curr = oldReferencedClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals(jarPath)) {
                newReferencedEntries.add(BuildPathSupport.getUpdatedEntry(curr, newReferencedEntry, changedAttributes, jproject));
                found = true;
            } else {
                newReferencedEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            newReferencedEntries.add(newReferencedEntry);
        }
        IClasspathEntry[] newReferencedClasspath = newReferencedEntries.toArray(new IClasspathEntry[newReferencedEntries.size()]);
        jproject.setRawClasspath(jproject.getRawClasspath(), newReferencedClasspath, jproject.getOutputLocation(), monitor);
    }

    public static void setEEComplianceOptions(IJavaProject javaProject, List<CPListElement> modifiedClassPathEntries) {
        for (CPListElement entry : modifiedClassPathEntries) {
            String eeID;
            IPath path;
            if (entry.getEntryKind() != 5 || (path = entry.getPath()).equals(entry.getOrginalPath()) || (eeID = JavaRuntime.getExecutionEnvironmentId((IPath)path)) == null) continue;
            BuildPathSupport.setEEComplianceOptions(javaProject, eeID, null);
            return;
        }
    }

    public static void setEEComplianceOptions(IJavaProject javaProject, String eeID, String newProjectCompliance) {
        IExecutionEnvironment ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeID);
        if (ee != null) {
            Map options = javaProject.getOptions(false);
            Map<String, String> eeOptions = BuildPathSupport.getEEOptions(ee);
            if (eeOptions != null) {
                String option;
                String inlineJSR;
                int i = 0;
                while (i < PREFS_COMPLIANCE.length) {
                    String option2 = PREFS_COMPLIANCE[i];
                    options.put(option2, eeOptions.get(option2));
                    ++i;
                }
                if (newProjectCompliance != null) {
                    JavaModelUtil.setDefaultClassfileOptions(options, newProjectCompliance);
                }
                if ((inlineJSR = eeOptions.get(option = "org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode")) != null) {
                    options.put(option, inlineJSR);
                }
                javaProject.setOptions(options);
            }
        }
    }

    public static Map<String, String> getEEOptions(IExecutionEnvironment ee) {
        if (ee == null) {
            return null;
        }
        Map eeOptions = ee.getComplianceOptions();
        if (eeOptions == null) {
            return null;
        }
        Object complianceOption = eeOptions.get("org.eclipse.jdt.core.compiler.compliance");
        if (!(complianceOption instanceof String)) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        JavaModelUtil.setComplianceOptions(options, (String)complianceOption);
        options.putAll(eeOptions);
        return options;
    }

    private static class UpdatedClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] fNewEntries;
        private IClasspathContainer fOriginal;

        public UpdatedClasspathContainer(IClasspathContainer original, IClasspathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fNewEntries;
        }

        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }
    }
}

