/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionInclusionEntryDialog
extends StatusDialog {
    private StringButtonDialogField fExclusionPatternDialog;
    private StatusInfo fExclusionPatternStatus;
    private IContainer fCurrSourceFolder;
    private String fExclusionPattern;
    private List<String> fExistingPatterns;
    private boolean fIsExclusion;

    public ExclusionInclusionEntryDialog(Shell parent, boolean isExclusion, String patternToEdit, List<String> existingPatterns, CPListElement entryToEdit) {
        super(parent);
        IWorkspaceRoot root;
        IResource res;
        String message;
        String title;
        this.fIsExclusion = isExclusion;
        this.fExistingPatterns = existingPatterns;
        if (isExclusion) {
            title = patternToEdit == null ? NewWizardMessages.ExclusionInclusionEntryDialog_exclude_add_title : NewWizardMessages.ExclusionInclusionEntryDialog_exclude_edit_title;
            message = Messages.format(NewWizardMessages.ExclusionInclusionEntryDialog_exclude_pattern_label, BasicElementLabels.getPathLabel(entryToEdit.getPath(), false));
        } else {
            title = patternToEdit == null ? NewWizardMessages.ExclusionInclusionEntryDialog_include_add_title : NewWizardMessages.ExclusionInclusionEntryDialog_include_edit_title;
            message = Messages.format(NewWizardMessages.ExclusionInclusionEntryDialog_include_pattern_label, BasicElementLabels.getPathLabel(entryToEdit.getPath(), false));
        }
        this.setTitle(title);
        if (patternToEdit != null) {
            this.fExistingPatterns.remove(patternToEdit);
        }
        if ((res = (root = entryToEdit.getJavaProject().getProject().getWorkspace().getRoot()).findMember(entryToEdit.getPath())) instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        this.fExclusionPatternStatus = new StatusInfo();
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        this.fExclusionPatternDialog = new StringButtonDialogField(adapter);
        this.fExclusionPatternDialog.setLabelText(message);
        this.fExclusionPatternDialog.setButtonLabel(NewWizardMessages.ExclusionInclusionEntryDialog_pattern_button);
        this.fExclusionPatternDialog.setDialogFieldListener(adapter);
        this.fExclusionPatternDialog.enableButton(this.fCurrSourceFolder != null);
        if (patternToEdit == null) {
            this.fExclusionPatternDialog.setText("");
        } else {
            this.fExclusionPatternDialog.setText(patternToEdit.toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(60);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        Label description = new Label(inner, 64);
        if (this.fIsExclusion) {
            description.setText(NewWizardMessages.ExclusionInclusionEntryDialog_exclude_description);
        } else {
            description.setText(NewWizardMessages.ExclusionInclusionEntryDialog_include_description);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        description.setLayoutData((Object)gd);
        this.fExclusionPatternDialog.doFillIntoGrid(inner, 3);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getLabelControl(null), widthHint);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternDialog.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fExclusionPatternDialog.getTextControl(null));
        this.fExclusionPatternDialog.postSetFocusOnDialogField(parent.getDisplay());
        ExclusionInclusionEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doChangeControlPressed() {
        IPath pattern = this.chooseExclusionPattern();
        if (pattern != null) {
            this.fExclusionPatternDialog.setText(pattern.toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fExclusionPatternStatus);
    }

    protected void checkIfPatternValid() {
        String pattern = this.fExclusionPatternDialog.getText().trim();
        if (pattern.length() == 0) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.ExclusionInclusionEntryDialog_error_empty);
            return;
        }
        Path path = new Path(pattern);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.ExclusionInclusionEntryDialog_error_notrelative);
            return;
        }
        if (this.fExistingPatterns.contains(pattern)) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.ExclusionInclusionEntryDialog_error_exists);
            return;
        }
        this.fExclusionPattern = pattern;
        this.fExclusionPatternStatus.setOK();
    }

    public String getExclusionPattern() {
        return this.fExclusionPattern;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.exclusion_pattern_dialog_context");
    }

    private IPath chooseExclusionPattern() {
        String message;
        String title;
        if (this.fIsExclusion) {
            title = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseExclusionPattern_title;
            message = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseExclusionPattern_description;
        } else {
            title = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseInclusionPattern_title;
            message = NewWizardMessages.ExclusionInclusionEntryDialog_ChooseInclusionPattern_description;
        }
        Path initialPath = new Path(this.fExclusionPatternDialog.getText());
        IPath[] res = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.fCurrSourceFolder, title, message, initialPath, false);
        if (res == null) {
            return null;
        }
        return res[0];
    }

    public static IPath[] chooseExclusionPattern(Shell shell, IContainer currentSourceFolder, String title, String message, IPath initialPath, boolean multiSelection) {
        Class[] acceptedClasses = new Class[]{IFolder.class, IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, multiSelection);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initialElement = null;
        if (initialPath != null) {
            IContainer curr = currentSourceFolder;
            int nSegments = initialPath.segmentCount();
            int i = 0;
            while (i < nSegments) {
                IResource elem = curr.findMember(initialPath.segment(i));
                if (elem != null) {
                    initialElement = elem;
                }
                if (!(elem instanceof IContainer)) break;
                curr = (IContainer)elem;
                ++i;
            }
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currentSourceFolder);
        dialog.setInitialSelection((Object)initialElement);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object[] objects = dialog.getResult();
            int existingSegments = currentSourceFolder.getFullPath().segmentCount();
            IPath[] resArr = new IPath[objects.length];
            int i = 0;
            while (i < objects.length) {
                IResource currRes = (IResource)objects[i];
                IPath path = currRes.getFullPath().removeFirstSegments(existingSegments).makeRelative();
                if (currRes instanceof IContainer) {
                    path = path.addTrailingSeparator();
                }
                resArr[i] = path;
                ++i;
            }
            return resArr;
        }
        return null;
    }

    private class ExclusionPatternAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private ExclusionPatternAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            ExclusionInclusionEntryDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField field) {
            ExclusionInclusionEntryDialog.this.doChangeControlPressed();
        }
    }
}

