/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UserLibraryMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        return id == 963 || id == 965 || id == 962 || id == 1010 || id == 964;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        final Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (!this.hasResolutions(marker) || shell == null) {
            return NO_RESOLUTION;
        }
        ArrayList<Object> resolutions = new ArrayList<Object>();
        final IJavaProject project = this.getJavaProject(marker);
        int id = marker.getAttribute("id", -1);
        if (id == 963) {
            Image image;
            String label;
            String[] arguments = CorrectionEngine.getProblemArguments(marker);
            final Path path = new Path(arguments[0]);
            if (path.segment(0).equals("org.eclipse.jdt.USER_LIBRARY")) {
                label = NewWizardMessages.UserLibraryMarkerResolutionGenerator_changetouserlib_label;
                image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                resolutions.add(new UserLibraryMarkerResolution(label, image){

                    public void run(IMarker m) {
                        UserLibraryMarkerResolutionGenerator.this.changeToExistingLibrary(shell, path, false, project);
                    }
                });
                if (path.segmentCount() == 2) {
                    String label2 = Messages.format(NewWizardMessages.UserLibraryMarkerResolutionGenerator_createuserlib_label, path.segment(1));
                    Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.library_obj.gif");
                    resolutions.add(new UserLibraryMarkerResolution(label2, image2){

                        public void run(IMarker m) {
                            UserLibraryMarkerResolutionGenerator.this.createUserLibrary(shell, path);
                        }
                    });
                }
            }
            label = NewWizardMessages.UserLibraryMarkerResolutionGenerator_changetoother;
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            resolutions.add(new UserLibraryMarkerResolution(label, image){

                public void run(IMarker m) {
                    UserLibraryMarkerResolutionGenerator.this.changeToExistingLibrary(shell, path, true, project);
                }
            });
        }
        if (project != null) {
            resolutions.add(new OpenBuildPathMarkerResolution(project));
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    protected void changeToExistingLibrary(Shell shell, IPath path, boolean isNew, final IJavaProject project) {
        try {
            IClasspathEntry[] res;
            IClasspathEntry[] entries = project.getRawClasspath();
            int idx = this.indexOfClasspath(entries, path);
            if (idx == -1) {
                return;
            }
            if (isNew) {
                res = BuildPathDialogAccess.chooseContainerEntries(shell, project, entries);
                if (res == null) {
                    return;
                }
            } else {
                IClasspathEntry resEntry = BuildPathDialogAccess.configureContainerEntry(shell, entries[idx], project, entries);
                if (resEntry == null) {
                    return;
                }
                res = new IClasspathEntry[]{resEntry};
            }
            final IClasspathEntry[] newEntries = new IClasspathEntry[entries.length - 1 + res.length];
            System.arraycopy(entries, 0, newEntries, 0, idx);
            System.arraycopy(res, 0, newEntries, idx, res.length);
            System.arraycopy(entries, idx + 1, newEntries, idx + res.length, entries.length - idx - 1);
            IWorkbenchWindow context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawClasspath(newEntries, project.getOutputLocation(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (JavaModelException e) {
            String title = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_title;
            String message = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_creationfailed_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_title;
            String message = NewWizardMessages.UserLibraryMarkerResolutionGenerator_error_applyingfailed_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private int indexOfClasspath(IClasspathEntry[] entries, IPath path) {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            if (curr.getEntryKind() == 5 && curr.getPath().equals(path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void createUserLibrary(Shell shell, IPath unboundPath) {
        String name = unboundPath.segment(1);
        String id = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("select_library", name);
        data.put("do_create", Boolean.TRUE);
        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)id, (String[])new String[]{id}, data).open();
    }

    private IJavaProject getJavaProject(IMarker marker) {
        return JavaCore.create(marker.getResource().getProject());
    }

    private static class OpenBuildPathMarkerResolution
    implements IMarkerResolution2 {
        private final IJavaProject fProject;

        public OpenBuildPathMarkerResolution(IJavaProject project) {
            this.fProject = project;
        }

        public String getDescription() {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_description, BasicElementLabels.getResourceName(this.fProject.getElementName()));
        }

        public Image getImage() {
            return JavaPluginImages.get("org.eclipse.jdt.ui.access_restriction_attrib.gif");
        }

        public String getLabel() {
            return CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label;
        }

        public void run(IMarker marker) {
            PreferencesUtil.createPropertyDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (IAdaptable)this.fProject, (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
        }
    }

    private static abstract class UserLibraryMarkerResolution
    implements IMarkerResolution2 {
        private final String fLabel;
        private final Image fImage;

        public UserLibraryMarkerResolution(String label, Image image) {
            this.fLabel = label;
            this.fImage = image;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return this.fImage;
        }
    }
}

