/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLibraryWizardPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension,
IClasspathContainerPageExtension2 {
    private CheckedListDialogField<CPUserLibraryElement> fLibrarySelector;
    private CPUserLibraryElement fEditResult;
    private Set<IPath> fUsedPaths;
    private boolean fIsEditMode;
    private IJavaProject fProject;
    private IClasspathEntry fOldClasspathEntry;

    public UserLibraryWizardPage() {
        super("UserLibraryWizardPage");
        this.setTitle(NewWizardMessages.UserLibraryWizardPage_title);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.updateDescription(null);
        this.fUsedPaths = new HashSet<IPath>();
        this.fProject = UserLibraryWizardPage.createPlaceholderProject();
        LibraryListAdapter adapter = new LibraryListAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.UserLibraryWizardPage_list_config_button};
        this.fLibrarySelector = new CheckedListDialogField<CPUserLibraryElement>(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrarySelector.setDialogFieldListener(adapter);
        this.fLibrarySelector.setLabelText(NewWizardMessages.UserLibraryWizardPage_list_label);
        this.fEditResult = null;
        this.updateStatus(this.validateSetting(Collections.<CPUserLibraryElement>emptyList()));
    }

    private static IJavaProject createPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create(project);
    }

    private void updateDescription(IClasspathEntry containerEntry) {
        if (containerEntry == null || containerEntry.getPath().segmentCount() != 2) {
            this.setDescription(NewWizardMessages.UserLibraryWizardPage_description_new);
        } else {
            this.setDescription(NewWizardMessages.UserLibraryWizardPage_description_edit);
        }
    }

    private List<CPUserLibraryElement> updateLibraryList() {
        HashSet<String> oldNames = new HashSet<String>();
        HashSet<String> oldCheckedNames = new HashSet<String>();
        List oldElements = this.fLibrarySelector.getElements();
        int i = 0;
        while (i < oldElements.size()) {
            CPUserLibraryElement curr = (CPUserLibraryElement)oldElements.get(i);
            oldNames.add(curr.getName());
            if (this.fLibrarySelector.isChecked(curr)) {
                oldCheckedNames.add(curr.getName());
            }
            ++i;
        }
        ArrayList<CPUserLibraryElement> entriesToCheck = new ArrayList<CPUserLibraryElement>();
        String[] names = JavaCore.getUserLibraryNames();
        Arrays.sort(names, Collator.getInstance());
        ArrayList<CPUserLibraryElement> elements = new ArrayList<CPUserLibraryElement>(names.length);
        int i2 = 0;
        while (i2 < names.length) {
            String curr = names[i2];
            IPath path = new Path("org.eclipse.jdt.USER_LIBRARY").append(curr);
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer(path, this.fProject);
                CPUserLibraryElement elem = new CPUserLibraryElement(curr, container, this.fProject);
                elements.add(elem);
                if (!oldCheckedNames.isEmpty()) {
                    if (oldCheckedNames.contains(curr)) {
                        entriesToCheck.add(elem);
                    }
                } else if (!oldNames.contains(curr)) {
                    entriesToCheck.add(elem);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i2;
        }
        this.fLibrarySelector.setElements(elements);
        return entriesToCheck;
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fLibrarySelector) {
            List<CPUserLibraryElement> list = this.fLibrarySelector.getCheckedElements();
            if (this.fIsEditMode) {
                if (list.size() > 1) {
                    if (this.fEditResult != null && list.remove(this.fEditResult)) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(this.fEditResult, false);
                    }
                    this.fEditResult = list.get(0);
                    int i = 1;
                    while (i < list.size()) {
                        this.fLibrarySelector.setCheckedWithoutUpdate(list.get(i), false);
                        ++i;
                    }
                } else if (list.size() == 1) {
                    this.fEditResult = list.get(0);
                }
            }
            this.updateStatus(this.validateSetting(list));
        }
    }

    private IStatus validateSetting(List<CPUserLibraryElement> selected) {
        int nSelected = selected.size();
        if (nSelected == 0) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectentry);
        }
        if (this.fIsEditMode && nSelected > 1) {
            return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_selectonlyone);
        }
        int i = 0;
        while (i < selected.size()) {
            CPUserLibraryElement curr = selected.get(i);
            if (this.fUsedPaths.contains(curr.getPath())) {
                return new StatusInfo(4, NewWizardMessages.UserLibraryWizardPage_error_alreadyoncp);
            }
            ++i;
        }
        return new StatusInfo();
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            HashMap<String, String> data = new HashMap<String, String>(3);
            if (this.fEditResult != null) {
                data.put("select_library", this.fEditResult.getName());
            }
            String id = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, data).open();
            List<CPUserLibraryElement> newEntries = this.updateLibraryList();
            if (newEntries.size() > 0) {
                if (this.fIsEditMode) {
                    this.fLibrarySelector.setChecked(newEntries.get(0), true);
                } else {
                    this.fLibrarySelector.setCheckedElements(newEntries);
                }
            }
        } else {
            this.fLibrarySelector.setCheckedElements(this.fLibrarySelector.getSelectedElements());
        }
    }

    private void doDoubleClicked(ListDialogField<CPUserLibraryElement> field) {
        CPUserLibraryElement elem;
        boolean state;
        List list;
        if (!(field != this.fLibrarySelector || (list = this.fLibrarySelector.getSelectedElements()).size() != 1 || (state = this.fLibrarySelector.isChecked(elem = (CPUserLibraryElement)list.get(0))) && this.fIsEditMode)) {
            this.fLibrarySelector.setChecked(elem, !state);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrarySelector}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrarySelector.getListControl(null));
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fLibrarySelector.setFocus();
        }
    }

    @Override
    public boolean finish() {
        return true;
    }

    @Override
    public IClasspathEntry getSelection() {
        if (this.fEditResult != null) {
            if (this.fOldClasspathEntry != null && this.fOldClasspathEntry.getPath().equals(this.fEditResult.getPath())) {
                return JavaCore.newContainerEntry(this.fEditResult.getPath(), this.fOldClasspathEntry.getAccessRules(), this.fOldClasspathEntry.getExtraAttributes(), this.fOldClasspathEntry.isExported());
            }
            return JavaCore.newContainerEntry(this.fEditResult.getPath(), false);
        }
        return null;
    }

    @Override
    public IClasspathEntry[] getNewContainers() {
        List<CPUserLibraryElement> selected = this.fLibrarySelector.getCheckedElements();
        IClasspathEntry[] res = new IClasspathEntry[selected.size()];
        int i = 0;
        while (i < res.length) {
            CPUserLibraryElement curr = selected.get(i);
            res[i] = JavaCore.newContainerEntry(curr.getPath(), false);
            ++i;
        }
        return res;
    }

    @Override
    public void setSelection(IClasspathEntry containerEntry) {
        this.fOldClasspathEntry = containerEntry;
        this.updateDescription(containerEntry);
        boolean bl = this.fIsEditMode = containerEntry != null;
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
        }
        String selected = null;
        if (containerEntry != null && containerEntry.getPath().segmentCount() == 2) {
            selected = containerEntry.getPath().segment(1);
        }
        this.updateLibraryList();
        if (selected != null) {
            List elements = this.fLibrarySelector.getElements();
            int i = 0;
            while (i < elements.size()) {
                CPUserLibraryElement curr = (CPUserLibraryElement)elements.get(i);
                if (curr.getName().equals(selected)) {
                    this.fLibrarySelector.setChecked(curr, true);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            IClasspathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryListAdapter
    implements IListAdapter<CPUserLibraryElement>,
    IDialogFieldListener {
        @Override
        public void dialogFieldChanged(DialogField field) {
            UserLibraryWizardPage.this.doDialogFieldChanged(field);
        }

        @Override
        public void customButtonPressed(ListDialogField<CPUserLibraryElement> field, int index) {
            UserLibraryWizardPage.this.doButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField<CPUserLibraryElement> field) {
        }

        @Override
        public void doubleClicked(ListDialogField<CPUserLibraryElement> field) {
            UserLibraryWizardPage.this.doDoubleClicked(field);
        }
    }
}

