/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.LibraryFilter;
import org.eclipse.jdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogPackageExplorer
implements IMenuListener,
IPostSelectionProvider,
ISetSelectionTarget {
    private TreeViewer fPackageViewer;
    private Menu fContextMenu;
    private DialogPackageExplorerActionGroup fActionGroup = null;
    private boolean fShowOutputFolders = false;
    private IStructuredSelection fCurrentSelection = new StructuredSelection();
    private IJavaProject fCurrJProject = null;
    private PackageContentProvider fContentProvider;

    public Control createControl(Composite parent) {
        this.fPackageViewer = new TreeViewer(parent, 2);
        this.fPackageViewer.setComparer(WorkingSetModel.COMPARER);
        this.fPackageViewer.addFilter((ViewerFilter)new PackageFilter());
        this.fPackageViewer.setComparator((ViewerComparator)new ExtendedJavaElementSorter());
        this.fPackageViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CPListElementAttribute attribute;
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (DialogPackageExplorer.this.fPackageViewer.isExpandable(element)) {
                    DialogPackageExplorer.this.fPackageViewer.setExpandedState(element, !DialogPackageExplorer.this.fPackageViewer.getExpandedState(element));
                } else if (element instanceof CPListElementAttribute && (attribute = (CPListElementAttribute)element).getKey().equals("output")) {
                    DialogPackageExplorer.this.fActionGroup.getEditOutputFolderAction().run();
                }
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fPackageViewer.getTree());
        this.fPackageViewer.getTree().setMenu(this.fContextMenu);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialogPackageExplorer.this.fContextMenu.dispose();
            }
        });
        return this.fPackageViewer.getControl();
    }

    public void setActionGroup(DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fActionGroup == null) {
            return;
        }
        JavaPlugin.createStandardGroups(manager);
        this.fActionGroup.fillContextMenu(manager);
    }

    public void setContentProvider() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = new PackageContentProvider();
        this.fContentProvider.setIsFlatLayout(true);
        PackageLabelProvider labelProvider = new PackageLabelProvider(36421324767273L, 3);
        this.fPackageViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(labelProvider, false));
    }

    public void setInput(IJavaProject project) {
        IJavaProject oldProject = this.fCurrJProject;
        this.fCurrJProject = project;
        if (this.fContentProvider != null) {
            this.fContentProvider.inputChanged((Viewer)this.fPackageViewer, oldProject, this.fCurrJProject);
        }
        this.fPackageViewer.setInput((Object)new Object[0]);
        ArrayList<IJavaProject> selectedElements = new ArrayList<IJavaProject>();
        selectedElements.add(this.fCurrJProject);
        this.setSelection(selectedElements);
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
        if (this.fActionGroup != null) {
            this.fActionGroup.dispose();
            this.fActionGroup = null;
        }
        this.fPackageViewer = null;
    }

    public void setSelection(final List<?> elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DialogPackageExplorer.this.fPackageViewer.refresh();
                    StructuredSelection selection = new StructuredSelection(elements);
                    DialogPackageExplorer.this.fPackageViewer.setSelection((ISelection)selection, true);
                    DialogPackageExplorer.this.fPackageViewer.getTree().setFocus();
                    if (elements.size() == 1 && elements.get(0) instanceof IJavaProject) {
                        DialogPackageExplorer.this.fPackageViewer.expandToLevel(elements.get(0), 1);
                    }
                }
            }, ResourcesPlugin.getWorkspace().getRoot(), 1, new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    public ISelection getSelection() {
        return this.fCurrentSelection;
    }

    public Control getViewerControl() {
        return this.fPackageViewer.getControl();
    }

    public void showOutputFolders(boolean showOutputFolders) {
        this.fShowOutputFolders = showOutputFolders;
        this.fActionGroup.getEditOutputFolderAction().showOutputFolders(showOutputFolders);
        this.fPackageViewer.refresh();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(((StructuredSelection)selection).toList());
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.addPostSelectionChangedListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.removePostSelectionChangedListener(listener);
    }

    public void selectReveal(ISelection selection) {
        this.setSelection(selection);
    }

    private final class ExtendedJavaElementSorter
    extends JavaElementComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CPListElementAttribute) {
                return -1;
            }
            if (e2 instanceof CPListElementAttribute) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class PackageContentProvider
    extends PackageExplorerContentProvider {
        public PackageContentProvider() {
            super(false);
        }

        public Object[] getElements(Object element) {
            if (DialogPackageExplorer.this.fCurrJProject == null || !DialogPackageExplorer.this.fCurrJProject.exists()) {
                return new Object[0];
            }
            return new Object[]{DialogPackageExplorer.this.fCurrJProject};
        }

        public Object[] getChildren(Object element) {
            Object[] children = super.getChildren(element);
            if ((element instanceof IPackageFragmentRoot && !ClasspathModifier.isInExternalOrArchive((IPackageFragmentRoot)element) || element instanceof IJavaProject && DialogPackageExplorer.this.fCurrJProject.isOnClasspath(DialogPackageExplorer.this.fCurrJProject)) && DialogPackageExplorer.this.fShowOutputFolders) {
                try {
                    IClasspathEntry entry = element instanceof IPackageFragmentRoot ? ((IPackageFragmentRoot)element).getRawClasspathEntry() : ClasspathModifier.getClasspathEntryFor(DialogPackageExplorer.this.fCurrJProject.getPath(), DialogPackageExplorer.this.fCurrJProject, 3);
                    CPListElement parent = CPListElement.createFromExisting(entry, DialogPackageExplorer.this.fCurrJProject);
                    CPListElementAttribute outputFolder = new CPListElementAttribute(parent, "output", parent.getAttribute("output"), true);
                    Object[] extendedChildren = new Object[children.length + 1];
                    System.arraycopy(children, 0, extendedChildren, 1, children.length);
                    extendedChildren[0] = outputFolder;
                    return extendedChildren;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return null;
                }
            }
            return children;
        }
    }

    private final class PackageFilter
    extends LibraryFilter {
        private OutputFolderFilter fOutputFolderFilter = new OutputFolderFilter();

        private PackageFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            if (!(element instanceof IFile)) break block10;
                            IFile file = (IFile)element;
                            if (file.getName().equals(".classpath") || file.getName().equals(".project")) {
                                return false;
                            }
                        }
                        if (!(element instanceof IPackageFragmentRoot)) break block11;
                        IClasspathEntry cpe = ((IPackageFragmentRoot)element).getRawClasspathEntry();
                        if (cpe == null || cpe.getEntryKind() == 5 || cpe.getEntryKind() == 1 || cpe.getEntryKind() == 4) {
                            return false;
                        }
                    }
                    if (!(element instanceof PackageFragmentRootContainer)) break block12;
                    return false;
                }
                if (!(element instanceof IPackageFragment)) break block13;
                IPackageFragment fragment = (IPackageFragment)element;
                if (fragment.isDefaultPackage() && !fragment.hasChildren()) {
                    return false;
                }
            }
            try {
                IFolder folder;
                if (element instanceof IFolder && (folder = (IFolder)element).getName().startsWith(".")) {
                    return false;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return this.fOutputFolderFilter.select(viewer, parentElement, element);
        }
    }

    private final class PackageLabelProvider
    extends AppearanceAwareLabelProvider {
        private CPListLabelProvider outputFolderLabel;

        public PackageLabelProvider(long textFlags, int imageFlags) {
            super(textFlags, imageFlags);
            this.outputFolderLabel = new CPListLabelProvider();
        }

        public String getText(Object element) {
            if (element instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getText(element);
            }
            String text = super.getText(element);
            try {
                IResource resource;
                IPackageFragmentRoot root;
                IJavaProject project;
                IPackageFragmentRoot root2;
                if (element instanceof IPackageFragmentRoot && (root2 = (IPackageFragmentRoot)element).exists() && ClasspathModifier.filtersSet(root2)) {
                    IClasspathEntry entry = root2.getRawClasspathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if (element instanceof IJavaProject && (project = (IJavaProject)element).exists() && project.isOnClasspath(project) && ClasspathModifier.filtersSet(root = project.findPackageFragmentRoot(project.getPath()))) {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && ClasspathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_Excluded, text);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return text;
        }

        public Color getForeground(Object element) {
            try {
                IResource resource;
                IPackageFragmentRoot root;
                IJavaProject project;
                IPackageFragmentRoot root2;
                if (element instanceof IPackageFragmentRoot && (root2 = (IPackageFragmentRoot)element).exists() && ClasspathModifier.filtersSet(root2)) {
                    return this.getBlueColor();
                }
                if (element instanceof IJavaProject && (project = (IJavaProject)element).exists() && project.isOnClasspath(project) && (root = project.findPackageFragmentRoot(project.getPath())) != null && ClasspathModifier.filtersSet(root)) {
                    return this.getBlueColor();
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && ClasspathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return this.getBlueColor();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return null;
        }

        private Color getBlueColor() {
            return Display.getCurrent().getSystemColor(9);
        }

        public Image getImage(Object element) {
            if (element instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getImage(element);
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.outputFolderLabel.dispose();
            super.dispose();
        }
    }
}

