/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public IncludeToBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public IncludeToBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private IncludeToBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 10);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_INCLUDE_ON_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_INCLUDE_ON_BUILDPATH);
    }

    @Override
    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Unexclude;
        }
        IResource resource = (IResource)this.getSelectedElements().get(0);
        String name = ClasspathModifier.escapeSpecialChars(BasicElementLabels.getResourceName(resource));
        if (resource instanceof IContainer) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFolder, name);
        }
        if (resource instanceof IFile) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFile, name);
        }
        return null;
    }

    public void run() {
        IResource resource = (IResource)this.getSelectedElements().get(0);
        final IJavaProject project = JavaCore.create(resource.getProject());
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List<?> result = IncludeToBuildpathAction.this.unExclude(IncludeToBuildpathAction.this.getSelectedElements(), project, monitor);
                        IncludeToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.IncludeToBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected List<?> unExclude(List<?> elements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            List<?> resultElements;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Including, 2 * elements.size());
            List<CPListElement> entries = ClasspathModifier.getExistingEntries(project);
            int i = 0;
            while (i < elements.size()) {
                IResource resource = (IResource)elements.get(i);
                IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, new SubProgressMonitor(monitor, 1));
                if (root != null) {
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, root);
                    ClasspathModifier.unExclude(resource, entry, project, new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(entries, project, new SubProgressMonitor(monitor, 4));
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(entries.toArray(new CPListElement[entries.size()]));
            this.informListeners(delta);
            List<?> list = resultElements = ClasspathModifier.getCorrespondingElements(elements, project);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            IJavaProject project;
            IResource resource;
            Iterator iter = elements.iterator();
            do {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                if (!(element instanceof IResource)) {
                    return false;
                }
                resource = (IResource)element;
                project = JavaCore.create(resource.getProject());
                if (project != null && project.exists()) continue;
                return false;
            } while (ClasspathModifier.isExcluded(resource, project));
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

