/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public ResetAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public ResetAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    public ResetAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 9);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
    }

    @Override
    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        Iterator<?> iterator = this.getSelectedElements().iterator();
        Object p = iterator.next();
        while (iterator.hasNext()) {
            Object q = iterator.next();
            if (p instanceof CPListElementAttribute && !(q instanceof CPListElementAttribute) || q instanceof CPListElementAttribute && !(p instanceof CPListElementAttribute)) {
                return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Reset;
            }
            p = q;
        }
        if (p instanceof CPListElementAttribute) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_SetOutputToDefault;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_ResetFilters;
    }

    public void run() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    Object firstElement = ResetAction.this.getSelectedElements().get(0);
                    IJavaProject project = null;
                    project = firstElement instanceof IJavaProject ? (IJavaProject)firstElement : (firstElement instanceof IPackageFragmentRoot ? ((IPackageFragmentRoot)firstElement).getJavaProject() : ((CPListElementAttribute)firstElement).getParent().getJavaProject());
                    List result = ResetAction.this.reset(ResetAction.this.getSelectedElements(), project, monitor);
                    ResetAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), "");
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List<Object> reset(List<?> selection, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Resetting, selection.size());
            List<CPListElement> entries = ClasspathModifier.getExistingEntries(project);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < selection.size()) {
                Object element = selection.get(i);
                if (element instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)element;
                    IPackageFragmentRoot root = element instanceof IJavaProject ? project.getPackageFragmentRoot(project.getResource()) : (IPackageFragmentRoot)element;
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, root);
                    ClasspathModifier.resetFilters(javaElement, entry, project, new SubProgressMonitor(monitor, 1));
                    result.add(javaElement);
                } else {
                    CPListElement selElement = ((CPListElementAttribute)element).getParent();
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, selElement);
                    CPListElementAttribute outputFolder = ClasspathModifier.resetOutputFolder(entry, project);
                    result.add(outputFolder);
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(entries, project, null);
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(entries.toArray(new CPListElement[entries.size()]));
            this.informListeners(delta);
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean canHandle(IStructuredSelection elements) {
        try {
            Iterator iterator = elements.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                Object element = iterator.next();
                if (element instanceof IJavaProject) {
                    IJavaProject project = (IJavaProject)element;
                    if (!project.isOnClasspath(project)) {
                        return false;
                    }
                    IClasspathEntry entry = ClasspathModifier.getClasspathEntryFor(project.getPath(), project, 3);
                    if (entry.getInclusionPatterns().length != 0) return true;
                    if (entry.getExclusionPatterns().length != 0) return true;
                    return false;
                }
                if (element instanceof IPackageFragmentRoot) {
                    if (!ClasspathModifier.filtersSet((IPackageFragmentRoot)element)) continue;
                    return true;
                }
                if (!(element instanceof CPListElementAttribute)) return false;
                if (!ClasspathModifier.isDefaultOutputFolder((CPListElementAttribute)element)) break;
            }
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

