/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.HintTextGroup;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ResetAllAction
extends BuildpathModifierAction {
    private final HintTextGroup fProvider;
    private final IRunnableContext fContext;
    private IJavaProject fJavaProject;
    private List<CPListElement> fEntries;
    private IPath fOutputLocation;

    public ResetAllAction(HintTextGroup provider, IRunnableContext context, ISetSelectionTarget selectionTarget) {
        super(null, selectionTarget, 6);
        this.fProvider = provider;
        this.fContext = context;
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CLEAR);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CLEAR);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_label);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
        this.setEnabled(false);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAll;
    }

    public void setBreakPoint(IJavaProject javaProject) {
        this.fJavaProject = javaProject;
        if (this.fJavaProject.exists()) {
            try {
                this.fEntries = ClasspathModifier.getExistingEntries(this.fJavaProject);
                this.fOutputLocation = this.fJavaProject.getOutputLocation();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return;
            }
            this.setEnabled(true);
        } else {
            JavaCore.addElementChangedListener(new IElementChangedListener(){

                public void elementChanged(ElementChangedEvent event) {
                    if (ResetAllAction.this.fJavaProject.exists()) {
                        try {
                            try {
                                ResetAllAction.this.fEntries = ClasspathModifier.getExistingEntries(ResetAllAction.this.fJavaProject);
                                ResetAllAction.this.fOutputLocation = ResetAllAction.this.fJavaProject.getOutputLocation();
                            }
                            catch (JavaModelException e) {
                                JavaPlugin.log(e);
                                JavaCore.removeElementChangedListener(this);
                                return;
                            }
                        }
                        finally {
                            JavaCore.removeElementChangedListener(this);
                        }
                        ResetAllAction.this.setEnabled(true);
                    }
                }
            }, 1);
        }
    }

    public void run() {
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 3);
                    try {
                        if (!ResetAllAction.this.hasChange(ResetAllAction.this.fJavaProject)) {
                            return;
                        }
                        try {
                            BuildpathDelta delta = new BuildpathDelta(ResetAllAction.this.getToolTipText());
                            ClasspathModifier.commitClassPath(ResetAllAction.this.fEntries, ResetAllAction.this.fJavaProject, monitor);
                            delta.setNewEntries(ResetAllAction.this.fEntries.toArray(new CPListElement[ResetAllAction.this.fEntries.size()]));
                            ResetAllAction.this.fJavaProject.setOutputLocation(ResetAllAction.this.fOutputLocation, monitor);
                            delta.setDefaultOutputLocation(ResetAllAction.this.fOutputLocation);
                            for (IResource resource : ResetAllAction.this.fProvider.getCreatedResources()) {
                                resource.delete(false, null);
                                delta.addDeletedResource(resource);
                            }
                            ResetAllAction.this.fProvider.resetCreatedResources();
                            ResetAllAction.this.informListeners(delta);
                            ResetAllAction.this.selectAndReveal((ISelection)new StructuredSelection((Object)ResetAllAction.this.fJavaProject));
                        }
                        catch (JavaModelException e) {
                            ResetAllAction.this.showExceptionDialog(e, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
                        }
                        catch (CoreException e) {
                            ResetAllAction.this.showExceptionDialog(e, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean canHandle(IStructuredSelection elements) {
        return this.fJavaProject != null;
    }

    private boolean hasChange(IJavaProject project) throws JavaModelException {
        if (!project.getOutputLocation().equals(this.fOutputLocation)) {
            return true;
        }
        IClasspathEntry[] currentEntries = project.getRawClasspath();
        if (currentEntries.length != this.fEntries.size()) {
            return true;
        }
        int i = 0;
        for (CPListElement oldEntrie : this.fEntries) {
            if (!oldEntrie.getClasspathEntry().equals(currentEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

