/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetComparator;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetConfigurationDialog
extends SelectionDialog {
    private List<IWorkingSet> fAllWorkingSets;
    private CheckboxTableViewer fTableViewer;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Button fSelectAll;
    private Button fDeselectAll;
    private Button fSortWorkingSet;
    private IWorkingSet[] fResult;
    private List<IWorkingSet> fAddedWorkingSets;
    private List<IWorkingSet> fRemovedWorkingSets;
    private Map<IWorkingSet, IWorkingSet> fEditedWorkingSets;
    private List<IWorkingSet> fRemovedMRUWorkingSets;
    private int nextButtonId = 1025;
    private boolean fIsSortingEnabled;
    private WorkingSetComparator fComparator;

    public WorkingSetConfigurationDialog(Shell parentShell, IWorkingSet[] allWorkingSets, boolean isSortingEnabled) {
        super(parentShell);
        this.setTitle(WorkingSetMessages.WorkingSetConfigurationDialog_title);
        this.setMessage(WorkingSetMessages.WorkingSetConfigurationDialog_message);
        this.fAllWorkingSets = new ArrayList<IWorkingSet>(allWorkingSets.length);
        int i = 0;
        while (i < allWorkingSets.length) {
            this.fAllWorkingSets.add(allWorkingSets[i]);
            ++i;
        }
        this.fIsSortingEnabled = isSortingEnabled;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.configure_working_set_dialog_context");
    }

    public IWorkingSet[] getSelection() {
        return this.fResult;
    }

    public void setSelection(IWorkingSet[] workingSets) {
        this.fResult = workingSets;
        this.setInitialSelections(workingSets);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setInitialSelection();
        this.updateButtonAvailability();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createTableViewer(inner);
        this.createOrderButtons(inner);
        this.createModifyButtons(composite);
        if (this.fIsSortingEnabled) {
            this.fTableViewer.setComparator(new ViewerComparator(this.getComparator()){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    return this.getComparator().compare(e1, e2);
                }
            });
        }
        this.fTableViewer.setInput(this.fAllWorkingSets);
        WorkingSetConfigurationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WorkingSetConfigurationDialog.this.updateButtonAvailability();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(20);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetConfigurationDialog.this.handleSelectionChanged();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (WorkingSetConfigurationDialog.this.fEditButton.isEnabled()) {
                    WorkingSetConfigurationDialog.this.editSelectedWorkingSet();
                }
            }
        });
    }

    private void createModifyButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        this.fNewButton = this.createButton(buttonComposite, this.nextButtonId++, WorkingSetMessages.WorkingSetConfigurationDialog_new_label, false);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.createWorkingSet();
            }
        });
        this.fEditButton = this.createButton(buttonComposite, this.nextButtonId++, WorkingSetMessages.WorkingSetConfigurationDialog_edit_label, false);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.editSelectedWorkingSet();
            }
        });
        this.fRemoveButton = this.createButton(buttonComposite, this.nextButtonId++, WorkingSetMessages.WorkingSetConfigurationDialog_remove_label, false);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.removeSelectedWorkingSets();
            }
        });
    }

    private void createOrderButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fUpButton = new Button(buttons, 8);
        this.fUpButton.setText(WorkingSetMessages.WorkingSetConfigurationDialog_up_label);
        this.setButtonLayoutData(this.fUpButton);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.moveUp(((IStructuredSelection)WorkingSetConfigurationDialog.this.fTableViewer.getSelection()).toList());
            }
        });
        this.fDownButton = new Button(buttons, 8);
        this.fDownButton.setText(WorkingSetMessages.WorkingSetConfigurationDialog_down_label);
        this.setButtonLayoutData(this.fDownButton);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.moveDown(((IStructuredSelection)WorkingSetConfigurationDialog.this.fTableViewer.getSelection()).toList());
            }
        });
        this.fSelectAll = new Button(buttons, 8);
        this.fSelectAll.setText(WorkingSetMessages.WorkingSetConfigurationDialog_selectAll_label);
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.selectAll();
            }
        });
        this.fDeselectAll = new Button(buttons, 8);
        this.fDeselectAll.setText(WorkingSetMessages.WorkingSetConfigurationDialog_deselectAll_label);
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.deselectAll();
            }
        });
        this.fSortWorkingSet = new Button(parent, 32);
        this.fSortWorkingSet.setText(WorkingSetMessages.WorkingSetConfigurationDialog_sort_working_sets);
        this.fSortWorkingSet.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fSortWorkingSet.setSelection(this.fIsSortingEnabled);
        this.fSortWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.fIsSortingEnabled = WorkingSetConfigurationDialog.this.fSortWorkingSet.getSelection();
                WorkingSetConfigurationDialog.this.updateButtonAvailability();
                if (WorkingSetConfigurationDialog.this.fIsSortingEnabled) {
                    WorkingSetConfigurationDialog.this.fTableViewer.setComparator(new ViewerComparator(WorkingSetConfigurationDialog.this.getComparator()){

                        public int compare(Viewer viewer, Object e1, Object e2) {
                            return this.getComparator().compare(e1, e2);
                        }
                    });
                } else {
                    WorkingSetConfigurationDialog.this.fTableViewer.setComparator(null);
                }
            }
        });
    }

    protected void okPressed() {
        List<IWorkingSet> newResult = this.getResultWorkingSets();
        this.fResult = newResult.toArray(new IWorkingSet[newResult.size()]);
        if (this.fIsSortingEnabled) {
            Collections.sort(this.fAllWorkingSets, this.getComparator());
        }
        this.setResult(newResult);
        super.okPressed();
    }

    private List<IWorkingSet> getResultWorkingSets() {
        Object[] checked = this.fTableViewer.getCheckedElements();
        return new ArrayList<Object>(Arrays.asList(checked));
    }

    protected void cancelPressed() {
        this.restoreAddedWorkingSets();
        this.restoreChangedWorkingSets();
        this.restoreRemovedWorkingSets();
        super.cancelPressed();
    }

    private void setInitialSelection() {
        List selections = this.getInitialElementSelections();
        if (!selections.isEmpty()) {
            this.fTableViewer.setCheckedElements(selections.toArray());
        }
    }

    private void createWorkingSet() {
        IWorkingSet workingSet;
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetNewWizard wizard = manager.createWorkingSetNewWizard(new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage"});
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0 && WorkingSetModel.isSupportedAsTopLevelElement(workingSet = wizard.getSelection())) {
            this.fAllWorkingSets.add(workingSet);
            this.fTableViewer.add((Object)workingSet);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet), true);
            this.fTableViewer.setChecked((Object)workingSet, true);
            manager.addWorkingSet(workingSet);
            this.fAddedWorkingSets.add(workingSet);
        }
    }

    private void editSelectedWorkingSet() {
        boolean firstEdit;
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet editWorkingSet = (IWorkingSet)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(editWorkingSet);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        IWorkingSet originalWorkingSet = this.fEditedWorkingSets.get(editWorkingSet);
        boolean bl = firstEdit = originalWorkingSet == null;
        if (firstEdit) {
            originalWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSet(editWorkingSet.getName(), editWorkingSet.getElements());
        } else {
            this.fEditedWorkingSets.remove(editWorkingSet);
        }
        dialog.create();
        if (dialog.open() == 0) {
            editWorkingSet = wizard.getSelection();
            if (this.fIsSortingEnabled) {
                this.fTableViewer.refresh();
            } else {
                this.fTableViewer.update((Object)editWorkingSet, null);
            }
            this.updateButtonAvailability();
        }
        this.fEditedWorkingSets.put(editWorkingSet, originalWorkingSet);
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    public int open() {
        this.fAddedWorkingSets = new ArrayList<IWorkingSet>();
        this.fRemovedWorkingSets = new ArrayList<IWorkingSet>();
        this.fEditedWorkingSets = new HashMap<IWorkingSet, IWorkingSet>();
        this.fRemovedMRUWorkingSets = new ArrayList<IWorkingSet>();
        return super.open();
    }

    private void removeSelectedWorkingSets() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            for (IWorkingSet workingSet : (IStructuredSelection)selection) {
                if (this.fAddedWorkingSets.contains(workingSet)) {
                    this.fAddedWorkingSets.remove(workingSet);
                } else {
                    IWorkingSet[] recentWorkingSets = manager.getRecentWorkingSets();
                    int i = 0;
                    while (i < recentWorkingSets.length) {
                        if (workingSet.equals(recentWorkingSets[i])) {
                            this.fRemovedMRUWorkingSets.add(workingSet);
                            break;
                        }
                        ++i;
                    }
                    this.fRemovedWorkingSets.add(workingSet);
                }
                this.fAllWorkingSets.remove(workingSet);
                manager.removeWorkingSet(workingSet);
            }
            this.fTableViewer.remove(((IStructuredSelection)selection).toArray());
        }
    }

    private void restoreAddedWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        Iterator<IWorkingSet> iterator = this.fAddedWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.removeWorkingSet(iterator.next());
        }
    }

    private void restoreChangedWorkingSets() {
        for (IWorkingSet editedWorkingSet : this.fEditedWorkingSets.keySet()) {
            IWorkingSet originalWorkingSet = this.fEditedWorkingSets.get(editedWorkingSet);
            if (!editedWorkingSet.getName().equals(originalWorkingSet.getName())) {
                editedWorkingSet.setName(originalWorkingSet.getName());
            }
            if (editedWorkingSet.getElements().equals(originalWorkingSet.getElements())) continue;
            editedWorkingSet.setElements(originalWorkingSet.getElements());
        }
    }

    private void restoreRemovedWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        Iterator<IWorkingSet> iterator = this.fRemovedWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.addWorkingSet(iterator.next());
        }
        iterator = this.fRemovedMRUWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.addRecentWorkingSet(iterator.next());
        }
    }

    private void updateButtonAvailability() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        boolean hasSelection = !selection.isEmpty();
        boolean hasSingleSelection = selection.size() == 1;
        this.fRemoveButton.setEnabled(hasSelection && this.areAllGlobalWorkingSets(selection));
        this.fEditButton.setEnabled(hasSingleSelection && ((IWorkingSet)selection.getFirstElement()).isEditable());
        if (this.fUpButton != null) {
            this.fUpButton.setEnabled(this.canMoveUp());
        }
        if (this.fDownButton != null) {
            this.fDownButton.setEnabled(this.canMoveDown());
        }
    }

    private boolean areAllGlobalWorkingSets(IStructuredSelection selection) {
        HashSet<IWorkingSet> globals = new HashSet<IWorkingSet>(Arrays.asList(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets()));
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (globals.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    private void moveUp(List<IWorkingSet> toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.fAllWorkingSets, toMoveUp));
            this.fTableViewer.reveal((Object)toMoveUp.get(0));
        }
    }

    private void moveDown(List<IWorkingSet> toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fAllWorkingSets), toMoveDown)));
            this.fTableViewer.reveal((Object)toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private void setElements(List<IWorkingSet> elements) {
        this.fAllWorkingSets = elements;
        this.fTableViewer.setInput(this.fAllWorkingSets);
        this.updateButtonAvailability();
    }

    private List<IWorkingSet> moveUp(List<IWorkingSet> elements, List<IWorkingSet> move) {
        int nElements = elements.size();
        ArrayList<IWorkingSet> res = new ArrayList<IWorkingSet>(nElements);
        IWorkingSet floating = null;
        int i = 0;
        while (i < nElements) {
            IWorkingSet curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    private List<IWorkingSet> reverse(List<IWorkingSet> p) {
        ArrayList<IWorkingSet> reverse = new ArrayList<IWorkingSet>(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    private boolean canMoveUp() {
        if (!this.fIsSortingEnabled) {
            int[] indc = this.fTableViewer.getTable().getSelectionIndices();
            int i = 0;
            while (i < indc.length) {
                if (indc[i] != i) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canMoveDown() {
        if (!this.fIsSortingEnabled) {
            int[] indc = this.fTableViewer.getTable().getSelectionIndices();
            int k = this.fAllWorkingSets.size() - 1;
            int i = indc.length - 1;
            while (i >= 0) {
                if (indc[i] != k) {
                    return true;
                }
                --i;
                --k;
            }
        }
        return false;
    }

    private void selectAll() {
        this.fTableViewer.setAllChecked(true);
    }

    private void deselectAll() {
        this.fTableViewer.setAllChecked(false);
    }

    public List<IWorkingSet> getNewlyAddedWorkingSets() {
        return this.fAddedWorkingSets;
    }

    public boolean isSortingEnabled() {
        return this.fIsSortingEnabled;
    }

    private WorkingSetComparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new WorkingSetComparator(true);
        }
        return this.fComparator;
    }

    public IWorkingSet[] getAllWorkingSets() {
        return this.fAllWorkingSets.toArray(new IWorkingSet[this.fAllWorkingSets.size()]);
    }

    private static class WorkingSetLabelProvider
    extends LabelProvider {
        private Map<ImageDescriptor, Image> fIcons = new Hashtable<ImageDescriptor, Image>();

        public void dispose() {
            for (Image icon : this.fIcons.values()) {
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue(object instanceof IWorkingSet);
            IWorkingSet workingSet = (IWorkingSet)object;
            ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = this.fIcons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            Assert.isTrue(object instanceof IWorkingSet);
            IWorkingSet workingSet = (IWorkingSet)object;
            return BasicElementLabels.getWorkingSetLabel(workingSet);
        }
    }
}

