/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class AddToClasspathAction
extends SelectionDispatchAction {
    public AddToClasspathAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddToClasspathAction_label);
        this.setToolTipText(ActionMessages.AddToClasspathAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.addjtoclasspath_action_context");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(AddToClasspathAction.checkEnabled(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged(e)) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private static boolean checkEnabled(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (AddToClasspathAction.canBeAddedToBuildPath(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeAddedToBuildPath(Object element) throws JavaModelException {
        return element instanceof IAdaptable && AddToClasspathAction.getCandidate((IAdaptable)element) != null;
    }

    private static IFile getCandidate(IAdaptable element) throws JavaModelException {
        IResource resource = (IResource)element.getAdapter(IResource.class);
        if (!(resource instanceof IFile) || !ArchiveFileFilter.isArchivePath(resource.getFullPath(), true)) {
            return null;
        }
        IJavaProject project = JavaCore.create(resource.getProject());
        if (project != null && project.exists() && project.findPackageFragmentRoot(resource.getFullPath()) == null) {
            return (IFile)resource;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            final IFile[] files = AddToClasspathAction.getJARFiles(selection);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask(ActionMessages.AddToClasspathAction_progressMessage, files.length);
                    int i = 0;
                    while (i < files.length) {
                        monitor.subTask(BasicElementLabels.getPathLabel(files[i].getFullPath(), false));
                        IJavaProject project = JavaCore.create(files[i].getProject());
                        this.addToClassPath(project, files[i].getFullPath(), new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }

                private void addToClassPath(IJavaProject project, IPath jarPath, IProgressMonitor monitor) throws JavaModelException {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IClasspathEntry[] entries = project.getRawClasspath();
                    IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                    System.arraycopy(entries, 0, newEntries, 0, entries.length);
                    newEntries[entries.length] = JavaCore.newLibraryEntry(jarPath, null, null, false);
                    project.setRawClasspath(newEntries, monitor);
                }
            };
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IFile[] getJARFiles(IStructuredSelection selection) throws JavaModelException {
        ArrayList<IFile> list = new ArrayList<IFile>();
        for (Object element : selection) {
            IFile file;
            if (!(element instanceof IAdaptable) || (file = AddToClasspathAction.getCandidate((IAdaptable)element)) == null) continue;
            list.add(file);
        }
        return list.toArray(new IFile[list.size()]);
    }
}

